/*
 * Decompiled with CFR 0.152.
 */
package io.teris.kite.rpc;

import io.teris.kite.Context;
import io.teris.kite.Deserializer;
import io.teris.kite.Serializer;
import io.teris.kite.rpc.ExceptionDataHolder;
import io.teris.kite.rpc.InvocationException;
import io.teris.kite.rpc.ServiceInvoker;
import io.teris.kite.rpc.ServiceProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;

final class ServiceProxyInvocationHandler
implements InvocationHandler {
    private final ServiceInvoker serviceInvoker;
    private final Serializer serializer;
    private final Map<String, Deserializer> deserializerMap = new HashMap<String, Deserializer>();
    private final Supplier<String> uidGenerator;

    ServiceProxyInvocationHandler(ServiceInvoker serviceInvoker, Serializer serializer, Map<String, Deserializer> deserializerMap, Supplier<String> uidGenerator) {
        this.serviceInvoker = Objects.requireNonNull(serviceInvoker, "RemoteRequestor is required");
        this.serializer = Objects.requireNonNull(serializer, "Serializer is required");
        this.uidGenerator = Objects.requireNonNull(uidGenerator, "Unique Id generator is required");
        if (deserializerMap != null) {
            this.deserializerMap.putAll(deserializerMap);
        }
    }

    @Override
    public Object invoke(Object $, Method method, Object[] args) throws Throwable {
        CompletableFuture promise = this.callRemote(method, args);
        if (Future.class.isAssignableFrom(method.getReturnType())) {
            return promise;
        }
        try {
            return promise.get();
        }
        catch (ExecutionException ex) {
            throw ex.getCause();
        }
    }

    <RS extends Serializable> CompletableFuture<RS> callRemote(Method method, Object[] args) {
        Map.Entry<Context, LinkedHashMap<String, Serializable>> parsedArgs;
        String routingKey;
        Type type;
        CompletableFuture result = new CompletableFuture();
        try {
            type = ServiceProxyUtil.returnType(method);
            routingKey = ServiceProxyUtil.route(method);
            parsedArgs = ServiceProxyUtil.arguments(method, args);
        }
        catch (RuntimeException ex) {
            result.completeExceptionally(ex);
            return result;
        }
        Context context = parsedArgs.getKey();
        LinkedHashMap<String, Serializable> payload = parsedArgs.getValue();
        Context requestContext = new Context(context);
        requestContext.put("X-Request-ID", this.uidGenerator.get());
        requestContext.put("Content-Type", this.serializer.contentType());
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)(payload != null ? this.serializer.serialize(payload) : CompletableFuture.completedFuture(null)).thenCompose(data -> this.serviceInvoker.call(routingKey, requestContext, (byte[])data))).thenCompose(entry -> {
            byte[] responseData;
            Context responseContext = (Context)entry.getKey();
            if (responseContext != null) {
                requestContext.putAll((Map)responseContext);
            }
            if ((responseData = (byte[])entry.getValue()) != null) {
                Deserializer deserializer = this.deserializerMap.getOrDefault(requestContext.get((Object)"Content-Type"), this.serializer.deserializer());
                return deserializer.deserialize(responseData, Typedef.class.getGenericSuperclass());
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(response -> {
            if (response == null) {
                return CompletableFuture.completedFuture(null);
            }
            Deserializer deserializer = this.deserializerMap.getOrDefault(requestContext.get((Object)"Content-Type"), this.serializer.deserializer());
            byte[] responseException = (byte[])response.get("exception");
            byte[] responsePayload = (byte[])response.get("payload");
            if (responseException != null) {
                return deserializer.deserialize(responseException, ExceptionDataHolder.class);
            }
            if (responsePayload != null) {
                return deserializer.deserialize(responsePayload, type);
            }
            return CompletableFuture.completedFuture(null);
        })).whenComplete((obj, t) -> {
            context.putAll((Map)requestContext);
            if (t != null && t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof RuntimeException) {
                result.completeExceptionally((Throwable)t);
            } else if (t != null) {
                result.completeExceptionally(new InvocationException(String.format("Failed to invoke %s.%s", method.getDeclaringClass().getSimpleName(), method.getName()), (Throwable)t));
            } else if (obj instanceof ExceptionDataHolder) {
                result.completeExceptionally(((ExceptionDataHolder)obj).exception());
            } else {
                Serializable res = obj;
                result.complete(res);
            }
        });
        return result;
    }

    private static class Typedef
    extends HashMap<String, Serializable> {
        private Typedef() {
        }
    }
}

