/*
 * Decompiled with CFR 0.152.
 */
package io.teris.kite.rpc;

import io.teris.kite.Deserializer;
import io.teris.kite.Serializer;
import io.teris.kite.rpc.ServiceFactory;
import io.teris.kite.rpc.ServiceInvoker;
import io.teris.kite.rpc.ServiceProxyInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

final class ServiceFactoryImpl
implements ServiceFactory {
    private final InvocationHandler invocationHandler;

    ServiceFactoryImpl(InvocationHandler invocationHandler) {
        this.invocationHandler = invocationHandler;
    }

    @Override
    @Nonnull
    public <S> S newInstance(@Nonnull Class<S> serviceClass) {
        Object res = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceClass}, this.invocationHandler);
        return (S)res;
    }

    static class BuilderImpl
    implements ServiceFactory.PreBuilder,
    ServiceFactory.Builder {
        private final ServiceInvoker serviceInvoker;
        private Serializer serializer = null;
        private Supplier<String> uidGenerator = () -> UUID.randomUUID().toString();
        private final Map<String, Deserializer> deserializerMap = new HashMap<String, Deserializer>();

        BuilderImpl(ServiceInvoker serviceInvoker) {
            this.serviceInvoker = serviceInvoker;
        }

        @Override
        @Nonnull
        public ServiceFactory.Builder serializer(@Nonnull Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        @Override
        @Nonnull
        public ServiceFactory.Builder deserializer(@Nonnull String contentType, @Nonnull Deserializer deserializer) {
            this.deserializerMap.put(contentType, deserializer);
            return this;
        }

        @Override
        @Nonnull
        public ServiceFactory.Builder deserializers(@Nonnull Map<String, Deserializer> deserializerMap) {
            this.deserializerMap.putAll(deserializerMap);
            return this;
        }

        @Override
        @Nonnull
        public ServiceFactory.Builder uidGenerator(@Nonnull Supplier<String> uidGenerator) {
            this.uidGenerator = uidGenerator;
            return this;
        }

        @Override
        @Nonnull
        public ServiceFactory build() {
            ServiceProxyInvocationHandler invocationHandler = new ServiceProxyInvocationHandler(this.serviceInvoker, this.serializer, this.deserializerMap, this.uidGenerator);
            return new ServiceFactoryImpl(invocationHandler);
        }
    }
}

