/*
 * Decompiled with CFR 0.152.
 */
package io.teris.kite.rpc;

import io.teris.kite.Context;
import io.teris.kite.Deserializer;
import io.teris.kite.Name;
import io.teris.kite.Serializer;
import io.teris.kite.rpc.BusinessException;
import io.teris.kite.rpc.ExceptionDataHolder;
import io.teris.kite.rpc.InvocationException;
import io.teris.kite.rpc.ServiceExporter;
import io.teris.kite.rpc.ServiceProxyUtil;
import io.teris.kite.rpc.ServiceValidator;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ServiceExporterImpl
implements ServiceExporter {
    private final Supplier<String> uidGenerator;
    private final Map<String, Map.Entry<Object, Method>> endpoints = new HashMap<String, Map.Entry<Object, Method>>();
    private final List<BiFunction<Context, Map.Entry<String, byte[]>, CompletableFuture<Context>>> preprocessors = new ArrayList<BiFunction<Context, Map.Entry<String, byte[]>, CompletableFuture<Context>>>();
    private final Serializer serializer;
    private final Map<String, Deserializer> deserializerMap = new HashMap<String, Deserializer>();
    private final ExecutorService executors;

    ServiceExporterImpl(Map<String, Map.Entry<Object, Method>> endpoints, List<BiFunction<Context, Map.Entry<String, byte[]>, CompletableFuture<Context>>> preprocessors, Serializer serializer, Map<String, Deserializer> deserializerMap, ExecutorService executors, Supplier<String> uidGenerator) {
        this.endpoints.putAll(endpoints);
        this.preprocessors.addAll(preprocessors);
        this.serializer = Objects.requireNonNull(serializer, "Serializer is required");
        this.deserializerMap.putAll(deserializerMap);
        this.executors = executors != null ? executors : Executors.newCachedThreadPool();
        this.uidGenerator = uidGenerator;
    }

    @Override
    @Nonnull
    public Set<String> routes() {
        return Collections.unmodifiableSet(new TreeSet<String>(this.endpoints.keySet()));
    }

    @Override
    @Nonnull
    public CompletableFuture<Map.Entry<Context, byte[]>> call(@Nonnull String route, @Nonnull Context context, @Nullable byte[] incomingData) {
        if (!context.containsKey((Object)"X-Request-ID")) {
            context.put("X-Request-ID", this.uidGenerator.get());
        }
        CompletionStage<Object> promise = CompletableFuture.completedFuture(context);
        AbstractMap.SimpleEntry<String, byte[]> routeAndData = new AbstractMap.SimpleEntry<String, byte[]>(route, incomingData);
        for (BiFunction<Context, Map.Entry<String, byte[]>, CompletableFuture<Context>> preprocessor : this.preprocessors) {
            promise = ((CompletableFuture)promise).thenCompose(c -> (CompletableFuture)preprocessor.apply((Context)c, (Map.Entry<String, byte[]>)routeAndData));
        }
        AtomicReference<Context> contextHolder = new AtomicReference<Context>(context);
        Map.Entry<Object, Method> endpoint = this.endpoints.get(route);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)promise).thenCompose(ctx -> {
            contextHolder.set((Context)ctx);
            if (endpoint != null && endpoint.getKey() != null && endpoint.getValue() != null) {
                return this.deserialize((Context)ctx, (Method)endpoint.getValue(), incomingData);
            }
            throw new InvocationException(String.format("No route to %s", route));
        })).thenCompose(args -> {
            Method method = (Method)Objects.requireNonNull(endpoint).getValue();
            Object service = endpoint.getKey();
            if (CompletableFuture.class.isAssignableFrom(method.getReturnType())) {
                try {
                    CompletableFuture invocationResult = (CompletableFuture)method.invoke(service, args);
                    return invocationResult.handle((obj, t) -> {
                        if (t != null) {
                            throw new BusinessException(t instanceof CompletionException ? t.getCause() : t);
                        }
                        return obj;
                    });
                }
                catch (ClassCastException | IllegalAccessException | InvocationTargetException ex) {
                    return CompletableFuture.supplyAsync(() -> {
                        throw new BusinessException(ex.getCause() != null ? ex.getCause() : ex);
                    });
                }
            }
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return method.invoke(service, args);
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    throw new BusinessException(ex.getCause() != null ? ex.getCause() : ex);
                }
            }, this.executors);
        })).handle((obj, t) -> {
            HashMap<String, Object> res = new HashMap<String, Object>();
            if (t instanceof CompletionException) {
                t = t.getCause();
            }
            if (t instanceof InvocationException) {
                res.put("exception", new ExceptionDataHolder((InvocationException)t));
                res.put("errorMessage", t.getMessage() != null ? t.getMessage() : t.toString());
            } else if (t instanceof BusinessException) {
                res.put("exception", new ExceptionDataHolder((BusinessException)t));
                res.put("errorMessage", t.getMessage() != null ? t.getMessage() : t.toString());
            } else {
                if (t != null) {
                    throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException((Throwable)t);
                }
                if (obj == null || Void.TYPE.isAssignableFrom(obj.getClass()) || Void.class.isAssignableFrom(obj.getClass())) {
                    res.put("payload", null);
                } else {
                    res.put("payload", (Serializable)obj);
                }
            }
            return res;
        })).thenCompose(arg_0 -> ((Serializer)this.serializer).serialize(arg_0))).thenApply(ser -> {
            Context ctx = (Context)contextHolder.get();
            ctx.put("Content-Type", this.serializer.contentType());
            return new AbstractMap.SimpleEntry<Context, byte[]>(ctx, (byte[])ser);
        });
    }

    CompletableFuture<Object[]> deserialize(@Nonnull Context context, @Nonnull Method method, @Nullable byte[] data) throws InvocationException {
        List initial = Arrays.stream(method.getParameters()).map(it -> null).collect(Collectors.toList());
        initial.set(0, context);
        if (data == null || data.length == 0) {
            return CompletableFuture.completedFuture(initial.toArray());
        }
        Deserializer deserializer = this.deserializerMap.getOrDefault(context.get((Object)"Content-Type"), this.serializer.deserializer());
        ConcurrentHashMap argMap = new ConcurrentHashMap();
        return ((CompletableFuture)deserializer.deserialize(data, Typedef.class.getGenericSuperclass()).thenCompose(rawArgs -> {
            ArrayList<CompletionStage> argPromises = new ArrayList<CompletionStage>();
            for (int i = 1; i < method.getParameterCount(); ++i) {
                byte[] paramData;
                Parameter param = method.getParameters()[i];
                Name nameAnnot = param.getAnnotation(Name.class);
                if (!rawArgs.containsKey(nameAnnot.value()) || (paramData = (byte[])rawArgs.remove(nameAnnot.value())) == null) continue;
                CompletionStage argPromise = deserializer.deserialize(paramData, param.getParameterizedType()).thenAccept(s -> argMap.put(nameAnnot.value(), s));
                argPromises.add(argPromise);
            }
            if (rawArgs.size() > 0) {
                String message = String.format("Too many arguments (%d instead of %s) to %s.%s", rawArgs.size() + method.getParameterCount() + 1, method.getParameterCount(), method.getDeclaringClass().getSimpleName(), method.getName());
                throw new InvocationException(message);
            }
            return CompletableFuture.allOf(argPromises.toArray(new CompletableFuture[0]));
        })).thenApply(vd -> {
            for (int i = 1; i < method.getParameterCount(); ++i) {
                Parameter param = method.getParameters()[i];
                Name nameAnnot = param.getAnnotation(Name.class);
                if (nameAnnot == null) continue;
                initial.set(i, argMap.get(nameAnnot.value()));
            }
            return initial.toArray();
        });
    }

    private static class Typedef
    extends HashMap<String, Serializable> {
        private Typedef() {
        }
    }

    static class BuilderImpl
    implements ServiceExporter.Builder {
        final Map<String, Map.Entry<Object, Method>> endpoints = new HashMap<String, Map.Entry<Object, Method>>();
        final List<BiFunction<Context, Map.Entry<String, byte[]>, CompletableFuture<Context>>> preprocessors = new ArrayList<BiFunction<Context, Map.Entry<String, byte[]>, CompletableFuture<Context>>>();
        private final Serializer serializer;
        private final Map<String, Deserializer> deserializerMap = new HashMap<String, Deserializer>();
        private ExecutorService executors = null;
        private Supplier<String> uidGenerator = () -> UUID.randomUUID().toString();

        BuilderImpl(Serializer serializer) {
            this.serializer = serializer;
        }

        @Override
        @Nonnull
        public ServiceExporter.Builder deserializer(@Nonnull String contentType, @Nonnull Deserializer deserializer) {
            this.deserializerMap.put(contentType, deserializer);
            return this;
        }

        @Override
        @Nonnull
        public ServiceExporter.Builder deserializers(@Nonnull Map<String, Deserializer> deserializerMap) {
            this.deserializerMap.putAll(deserializerMap);
            return this;
        }

        @Override
        @Nonnull
        public ServiceExporter.Builder executors(@Nonnull ExecutorService executors) {
            this.executors = executors;
            return this;
        }

        @Override
        @Nonnull
        public ServiceExporter.Builder uidGenerator(@Nonnull Supplier<String> uidGenerator) {
            this.uidGenerator = uidGenerator;
            return this;
        }

        @Override
        @Nonnull
        public ServiceExporter.Builder preprocessor(BiFunction<Context, Map.Entry<String, byte[]>, CompletableFuture<Context>> preprocessor) {
            this.preprocessors.add(preprocessor);
            return this;
        }

        @Override
        @Nonnull
        public <S> ServiceExporter.Builder export(@Nonnull Class<S> serviceClass, @Nonnull S service) throws InvocationException {
            ServiceValidator.validate(serviceClass);
            for (Method method : serviceClass.getDeclaredMethods()) {
                String route = ServiceProxyUtil.route(method);
                this.endpoints.put(route, new AbstractMap.SimpleEntry<S, Method>(service, method));
            }
            return this;
        }

        @Override
        @Nonnull
        public ServiceExporter build() {
            return new ServiceExporterImpl(this.endpoints, this.preprocessors, this.serializer, this.deserializerMap, this.executors, this.uidGenerator);
        }
    }
}

