/*
 * Decompiled with CFR 0.152.
 */
package io.teris.kite.rpc;

import io.teris.kite.rpc.BusinessException;
import io.teris.kite.rpc.InvocationException;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class ExceptionDataHolder
implements Serializable {
    private static final long serialVersionUID = 23489765234056L;
    public String message = "";
    public String type = InvocationException.class.getSimpleName();
    StackTraceElement[] stackTrace = new StackTraceElement[0];

    protected ExceptionDataHolder() {
    }

    ExceptionDataHolder(@Nonnull InvocationException ex) {
        this.message = ex.getMessage() != null ? ex.getMessage() : "Technical exception";
        this.type = ex.getClass().getSimpleName();
        this.stackTrace = ex.getStackTrace();
    }

    ExceptionDataHolder(@Nonnull BusinessException ex) {
        this.message = ex.getMessage() != null ? ex.getMessage() : "Business exception";
        this.type = ex.getClass().getSimpleName();
        this.stackTrace = ex.getStackTrace();
    }

    @Nonnull
    public RuntimeException exception() {
        if (BusinessException.class.getSimpleName().equalsIgnoreCase(this.type)) {
            return new BusinessException(this.message, this.stackTrace);
        }
        return new InvocationException(this.message, this.stackTrace);
    }
}

