/*
 * Decompiled with CFR 0.152.
 */
package io.teris.kite.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import io.teris.kite.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class JsonSerializerBuilder {
    private final GsonBuilder builder = new GsonBuilder().registerTypeAdapter(LocalDate.class, (Object)new LocalDateSerializer()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateDeserializer()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeSerializer()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeDeserializer()).registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeSerializer()).registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeDeserializer()).registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeSerializer()).registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeDeserializer());
    private Charset charset = StandardCharsets.UTF_8;

    JsonSerializerBuilder() {
    }

    public JsonSerializerBuilder registerTypeAdapter(Type type, Object typeAdapter) {
        this.builder.registerTypeAdapter(type, typeAdapter);
        return this;
    }

    public JsonSerializerBuilder withCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public GsonBuilder rawBuilder() {
        return this.builder;
    }

    public JsonSerializer build() {
        return new JsonSerializer(this.builder, this.charset);
    }

    private static class OffsetDateTimeSerializer
    implements com.google.gson.JsonSerializer<OffsetDateTime> {
        private OffsetDateTimeSerializer() {
        }

        public JsonElement serialize(OffsetDateTime date, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(date.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
    }

    private static class OffsetDateTimeDeserializer
    implements JsonDeserializer<OffsetDateTime> {
        private OffsetDateTimeDeserializer() {
        }

        public OffsetDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return OffsetDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(json.getAsString()));
        }
    }

    private static class ZonedDateTimeSerializer
    implements com.google.gson.JsonSerializer<ZonedDateTime> {
        private ZonedDateTimeSerializer() {
        }

        public JsonElement serialize(ZonedDateTime date, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(date.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
        }
    }

    private static class ZonedDateTimeDeserializer
    implements JsonDeserializer<ZonedDateTime> {
        private ZonedDateTimeDeserializer() {
        }

        public ZonedDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return ZonedDateTime.from(DateTimeFormatter.ISO_ZONED_DATE_TIME.parse(json.getAsString()));
        }
    }

    private static class LocalDateTimeSerializer
    implements com.google.gson.JsonSerializer<LocalDateTime> {
        private LocalDateTimeSerializer() {
        }

        public JsonElement serialize(LocalDateTime date, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(date.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
    }

    private static class LocalDateTimeDeserializer
    implements JsonDeserializer<LocalDateTime> {
        private LocalDateTimeDeserializer() {
        }

        public LocalDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return LocalDateTime.from(DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(json.getAsString()));
        }
    }

    private static class LocalDateSerializer
    implements com.google.gson.JsonSerializer<LocalDate> {
        private LocalDateSerializer() {
        }

        public JsonElement serialize(LocalDate date, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(date.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
    }

    private static class LocalDateDeserializer
    implements JsonDeserializer<LocalDate> {
        private LocalDateDeserializer() {
        }

        public LocalDate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return LocalDate.from(DateTimeFormatter.ISO_DATE.parse(json.getAsString()));
        }
    }
}

