/*
 * Decompiled with CFR 0.152.
 */
package io.teris.kite.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.teris.kite.Deserializer;
import io.teris.kite.Serializer;
import io.teris.kite.gson.JsonDeserializer;
import io.teris.kite.gson.JsonSerializerBuilder;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class JsonSerializer
implements Serializer {
    private static final String CONTENT_TYPE = "application/json";
    private final Deserializer deserializer;
    private final Gson gson;
    private final Charset charset;

    public JsonSerializer(GsonBuilder builder) {
        this(builder, StandardCharsets.UTF_8);
    }

    public JsonSerializer(GsonBuilder builder, Charset charset) {
        this.gson = builder.create();
        this.charset = charset;
        this.deserializer = new JsonDeserializer(builder, charset);
    }

    public static JsonSerializerBuilder builder() {
        return new JsonSerializerBuilder();
    }

    @Nonnull
    public <CT extends Serializable> CompletableFuture<byte[]> serialize(@Nonnull CT value) {
        return CompletableFuture.supplyAsync(() -> this.gson.toJson((Object)value).getBytes(this.charset));
    }

    @Nonnull
    public String contentType() {
        return CONTENT_TYPE;
    }

    @Nonnull
    public Deserializer deserializer() {
        return this.deserializer;
    }
}

