/*
 * Decompiled with CFR 0.152.
 */
package io.teris.kite.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.teris.kite.Deserializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class JsonDeserializer
implements Deserializer {
    private final Gson gson;
    private final Charset charset;

    public JsonDeserializer(GsonBuilder builder) {
        this(builder, StandardCharsets.UTF_8);
    }

    public JsonDeserializer(GsonBuilder builder, Charset charset) {
        this.gson = builder.registerTypeAdapter(Serializable.class, (Object)new SerializableDeserializer(charset)).create();
        this.charset = charset;
    }

    @Nonnull
    public <CT extends Serializable> CompletableFuture<CT> deserialize(@Nonnull byte[] data, @Nonnull Class<CT> clazz) {
        return CompletableFuture.supplyAsync(() -> (Serializable)this.gson.fromJson(new String(data, this.charset), clazz));
    }

    @Nonnull
    public <CT extends Serializable> CompletableFuture<CT> deserialize(@Nonnull byte[] data, @Nonnull Type type) {
        return CompletableFuture.supplyAsync(() -> (Serializable)this.gson.fromJson(new String(data, this.charset), type));
    }

    private static class SerializableDeserializer
    implements com.google.gson.JsonDeserializer<Serializable> {
        private final Charset charset;

        SerializableDeserializer(Charset charset) {
            this.charset = charset;
        }

        public Serializable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.toString().getBytes(this.charset);
        }
    }
}

