
package io.teliver.sdk.util;

import android.content.Context;
import android.os.AsyncTask;

import io.teliver.sdk.core.TLog;
import io.teliver.sdk.models.TConstants;

import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;


public class TRestCall extends AsyncTask<String, Integer, String> {

    private ResponseListener listener;

    private RequestBody requestBody;

    private HTTP_TYPE httpType;

    private TPreference preference;

    public enum HTTP_TYPE {
        TYPE_POST, TYPE_PATCH, TYPE_GET
    }

    public interface ResponseListener {
        void onResponse(String result);
    }

    public TRestCall(Context context) {
        httpType = HTTP_TYPE.TYPE_POST;
        preference = new TPreference(context);
    }

    public void setHttpType(HTTP_TYPE httpType) {
        this.httpType = httpType;
    }


    public void setCallBackListener(ResponseListener finishedListener) {
        this.listener = finishedListener;
    }

    public void requestApi(String append, RequestBody requestBody) {
        this.requestBody = requestBody;
        this.execute("https://api.teliver.xyz/api/v1/sdk/" + append);
        //this.execute("http://stagingapi.teliver.io/api/v1/sdk/" + append);
    }

    void requestApi(String url, String append, RequestBody requestBody) {
        this.requestBody = requestBody;
        this.execute(url + append);
    }

    @Override
    protected String doInBackground(String... params) {
        try {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.connectTimeout(5, TimeUnit.MINUTES)
                    .writeTimeout(5, TimeUnit.MINUTES)
                    .readTimeout(5, TimeUnit.MINUTES);
            OkHttpClient client = builder.build();
            Request.Builder request = new Request.Builder();
            request.url(params[0]);
            request.addHeader("Content-Type", "application/x-www-form-urlencoded");
            request.addHeader("app-key", preference.getString(TConstants.API_KEY));
            request.addHeader("Authorization", "Bearer " + preference.getAuthToken());
            if (httpType == HTTP_TYPE.TYPE_POST)
                request.post(requestBody);
            else if (httpType == HTTP_TYPE.TYPE_GET)
                request.get();
            else request.patch(requestBody);
            ResponseBody body = client.newCall(request.build())
                    .execute().body();
            return body == null ? "" : TUtils.clearNull(body.string());
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void onPostExecute(String result) {
        super.onPostExecute(result);
        TLog.log(result);
        if (this.listener != null)
            listener.onResponse(TUtils.clearNull(result));
    }
}