
package io.teliver.sdk.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

@SuppressLint("CommitPrefEdits")
public class TPreference {

    private static final String USER_ID = "teliver_user_id", T_PUSH_TOKEN
            = "t_push_token", AUTH_TOKEN = "dots_auth_token";

    private SharedPreferences preferences;

    private Editor mEditor;

    public TPreference(Context context) {
        String prefName = "teliver_pref_" + context.getPackageName();
        preferences = context.getSharedPreferences(prefName, Context.MODE_PRIVATE);
        mEditor = preferences.edit();
    }

    public void storeString(String key, String value) {
        mEditor.putString(key, value);
        mEditor.apply();
    }

    public String getString(String key) {
        return preferences.getString(key, "");
    }

    public String getUserId() {
        return TUtils.clearNull(getString(USER_ID));
    }

    public void saveUserId(String id) {
        storeString(USER_ID, id);
    }

    public void savePushToken(String token) {
        storeString(T_PUSH_TOKEN, token);
    }

    public String getPushToken() {
        return TUtils.clearNull(getString(T_PUSH_TOKEN));
    }

    public void saveAuthToken(String authToken) {
        storeString(AUTH_TOKEN, authToken);
    }

    public String getAuthToken() {
        return TUtils.clearNull(getString(AUTH_TOKEN));
    }

}
