package io.teliver.sdk.util;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.os.AsyncTask;

import io.teliver.sdk.core.TLog;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TConverter extends AsyncTask<Location, Void, List<Address>> {

    private Converter converter;

    private Geocoder geocoder;

    public TConverter(Context context) {
        geocoder = new Geocoder(context, Locale.getDefault());
    }

    public interface Converter {
        void onLocationString(String location);
    }

    public void convertLatLng(Location location, Converter converter) {
        try {
            this.converter = converter;
            if (location != null && converter != null)
                this.execute(location);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected List<Address> doInBackground(Location... params) {
        try {
            Location location = params[0];
            return geocoder.getFromLocation(location.getLatitude()
                    , location.getLongitude(), 1);
        } catch (Exception e) {
            TLog.log(" Converter: Geo coder error");
        }
        return new ArrayList<>();
    }

    @Override
    protected void onPostExecute(List<Address> addresses) {
        super.onPostExecute(addresses);
        try {
            if (addresses == null || addresses.isEmpty())
                converter.onLocationString("");
            else {
                Address address = addresses.get(0);
                converter.onLocationString(address == null ? "" : TUtils
                        .clearNull(address.getAddressLine(0)));
            }
        } catch (Exception e) {
            converter.onLocationString("");
        }
    }
}
