package io.teliver.sdk.util;

import android.annotation.SuppressLint;
import android.content.Context;

import io.teliver.sdk.core.TLog;

import org.eclipse.paho.android.service.MqttAndroidClient;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MessageClient {

    private MqttAndroidClient client;

    private IMqttActionListener listener;

    private Context context;

    @SuppressLint("StaticFieldLeak")
    private static MessageClient messageClient;

    private static final String MSG_SERVER_URI = "tcp://mqtt.teliver.xyz:5678";
    // private static final String MSG_SERVER_URI = "tcp://realtime.teliver.io:1225";

    public static MessageClient getInstance(Context context) {
        if (messageClient == null)
            messageClient = new MessageClient(context);
        return messageClient;
    }

    private MessageClient(Context context) {
        TLog.log("Connecting msg client::");
        this.context = context;
        client = new MqttAndroidClient(context, MSG_SERVER_URI, TUtils.getDeviceId(context)
                + "@" + context.getPackageName(), MqttAndroidClient.Ack.MANUAL_ACK);
    }

    void setCallbackListener(MqttCallback callbackListener) {
        client.setCallback(callbackListener);
    }

    public void setConnectionListener(IMqttActionListener listener) {
        this.listener = listener;
    }

    public boolean isConnected() {
        return client.isConnected();
    }

    void connect() {
        try {
            if (isConnected())
                TLog.log("Client already connected");
            else
                client.connect(TUtils.options(context), this, listener);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        try {
            TLog.log("Disconnecting client");
            if (isConnected())
                client.disconnect();
            messageClient = null;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void publishData(String trackingId, MqttMessage mqttMessage, IMqttActionListener listener) {
        try {
            if (!isConnected()) {
                TLog.log("Sending Location error:Client not connected::");
                return;
            }
            client.publish(trackingId, mqttMessage, false, listener);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    void subscribeTopic(String trackingId) {
        try {
            client.subscribe(trackingId, 1, context, null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    void unSubscribe(String trackingId) {
        try {
            client.unsubscribe(trackingId);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
