package io.teliver.sdk.models;


public class UserBuilder {

    private String id;

    private String phone;

    private String email;

    private boolean isRegister;

    private String type;

    private String name;

    public enum USER_TYPE {
        CONSUMER, OPERATOR
    }

    public UserBuilder(String userId) {
        this.id = userId;
    }

    public UserBuilder setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public UserBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public UserBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public UserBuilder registerPush() {
        this.isRegister = true;
        return this;
    }

    public UserBuilder setUserType(USER_TYPE type) {
        this.type = type == USER_TYPE.OPERATOR ? "1" : "2";
        return this;
    }

    public User build() {
        return new User(id, type, name, phone, email, isRegister);
    }
}
