package io.teliver.sdk.models;


import com.google.gson.annotations.SerializedName;
import io.teliver.sdk.util.TUtils;

import java.util.List;

public class TrackingIDStatus extends TResponse {

    @SerializedName("data")
    private List<IDStatus> statusList;

    public List<IDStatus> getStatusList() {
        return statusList;
    }

    public class IDStatus {

        @SerializedName("_id")
        private String trackingId;

        private String status;

        private Double[] location;

        public String getTrackingId() {
            return trackingId;
        }

        public boolean isActive() {
            return TUtils.clearNull(status).equals("1");
        }

        public TLocation getStartingLocation() {
            String lat = "0.0", lon = "0.0";
            if (location.length==2) {

                lat = location[1].toString();
                lon = location[0].toString();
            }
            TLocation location = new TLocation();
            location.setLatitude(Double.parseDouble(lat));
            location.setLongitude(Double.parseDouble(lon));

            return location;
        }
    }

}
