package io.teliver.sdk.models;

import io.teliver.sdk.core.TaskListListener;

public class TaskBuilder {


    private String status, startDate, endDate;

    private int page, limit;

    private TaskListListener taskListener;

    public TaskBuilder() {

    }

    public TaskBuilder withStatus(String title) {
        this.status = title;
        return this;
    }

    public TaskBuilder withPage(int page) {
        this.page = page;
        return this;
    }


    public TaskBuilder withLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public TaskBuilder withListener(TaskListListener listener) {
        this.taskListener = listener;
        return this;
    }


    public TaskBuilder withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    public TaskBuilder withEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }


    public TaskOptions build() {
        TaskOptions taskOptions = new TaskOptions();
        taskOptions.setStatus(status);
        taskOptions.setStartDate(startDate);
        taskOptions.setEndDate(endDate);
        taskOptions.setPage(page);
        taskOptions.setLimit(limit);
        taskOptions.setTaskListener(taskListener);
        return taskOptions;
    }


}
