package io.teliver.sdk.models;

import com.google.gson.annotations.SerializedName;
import io.teliver.sdk.util.TUtils;

import org.json.JSONException;
import org.json.JSONObject;

public class Task {

    @SerializedName("updated_at")
    private String updatedAt;

    @SerializedName("created_at")
    private String createdAt;

    @SerializedName("order_id")
    private String orderId;

    @SerializedName("pickup")
    private Pickup pickUp;

    @SerializedName("drop")
    private Drop drop;

    @SerializedName("task_id")
    private String taskId;

    private String status;

    private String notes;

    private Object properties;

    public String getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public Driver getDriver() {
        return driver;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    @SerializedName("driver")
    private Driver driver;

    public Drop getDrop() {
        return drop == null ? new Drop() : drop;
    }

    public void setDrop(Drop drop) {
        this.drop = drop;
    }

    private String time;

    private String type;

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Pickup getPickUp() {
        return pickUp == null ? new Pickup() : pickUp;
    }

    public void setPickUp(Pickup pickUp) {
        this.pickUp = pickUp;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getNotes() {
        return notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Task() {
    }

    private String getProperty() {
        return properties == null ? "{}" : properties.toString();
    }

    public JSONObject getProperties() {
        try {
            return new JSONObject(TUtils.getGson().toJson(properties));
        } catch (JSONException e) {
            return new JSONObject();
        }
    }
}
