package io.teliver.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

public class Pickup implements Parcelable {

    @SerializedName("customer")
    private Customer customer;

    @SerializedName("is_complete")
    private boolean isComplete;

    private String address;

    @SerializedName("lnglat")
    private List<Double> latLongs;

    Pickup() {
        // Default constructor
    }

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public List<Double> getLatLongs() {
        return latLongs;
    }

    public void setLatLongs(List<Double> latLongs) {
        this.latLongs = latLongs;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(customer, flags);
        dest.writeByte((byte) (isComplete ? 1 : 0));
        dest.writeString(address);
        dest.writeList(latLongs);
    }

    private Pickup(Parcel in) {
        customer = in.readParcelable(Customer.class.getClassLoader());
        isComplete = in.readByte() == 1;
        address = in.readString();
        latLongs = new ArrayList<>();
        in.readList(this.latLongs, Double.class.getClassLoader());
    }

    public static final Creator<Pickup> CREATOR = new Creator<Pickup>() {
        @Override
        public Pickup createFromParcel(Parcel source) {
            return new Pickup(source);
        }

        @Override
        public Pickup[] newArray(int size) {
            return new Pickup[size];
        }
    };

    public boolean isComplete() {
        return isComplete;
    }

    public void setComplete(boolean complete) {
        isComplete = complete;
    }
}
