package io.teliver.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

public class Drop implements Parcelable {

    @SerializedName("customer")
    private Customer customer;

    @SerializedName("is_complete")
    private boolean isComplete;

    private String address;

    @SerializedName("lnglat")
    private List<Double> latLongs;

    Drop() {
        // Default constructor
    }

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public List<Double> getLatLongs() {
        return latLongs;
    }

    public void setLatLongs(List<Double> latLongs) {
        this.latLongs = latLongs;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.customer, flags);
        dest.writeString(this.address);
        dest.writeByte((byte) (isComplete ? 1 : 0));
        dest.writeList(this.latLongs);
    }

    private Drop(Parcel in) {
        this.customer = in.readParcelable(Customer.class.getClassLoader());
        this.address = in.readString();
        this.latLongs = new ArrayList<>();
        this.isComplete = in.readByte() == 1;
        in.readList(this.latLongs, Double.class.getClassLoader());
    }

    public static final Creator<Drop> CREATOR = new Creator<Drop>() {
        @Override
        public Drop createFromParcel(Parcel source) {
            return new Drop(source);
        }

        @Override
        public Drop[] newArray(int size) {
            return new Drop[size];
        }
    };

    public boolean isComplete() {
        return isComplete;
    }

    public void setComplete(boolean complete) {
        isComplete = complete;
    }
}
