/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.validation;

import com.google.common.base.Strings;
import com.squareup.javapoet.TypeName;
import io.t28.shade.annotation.Property;
import io.t28.shade.processor.metadata.PropertyMethodMetadata;
import io.t28.shade.processor.validation.ValidationException;
import io.t28.shade.processor.validation.Validator;
import javax.annotation.Nonnull;

public class PropertyMethodValidator
implements Validator<PropertyMethodMetadata> {
    private static final String ANNOTATION_NAME = Property.class.getSimpleName();

    @Override
    public void validate(@Nonnull PropertyMethodMetadata metadata) throws ValidationException {
        String methodName = metadata.getSimpleName();
        if (!metadata.isAbstract()) {
            throw new ValidationException("Method(%s) annotated with @%s must be an abstract method", methodName, ANNOTATION_NAME);
        }
        if (metadata.hasParameters()) {
            throw new ValidationException("Method(%s) annotated with @%s must not receive any parameters", methodName, ANNOTATION_NAME);
        }
        TypeName returnType = metadata.getReturnTypeName();
        if (returnType.equals((Object)TypeName.VOID)) {
            throw new ValidationException("Method(%s) annotated with @%s must not return void", methodName, ANNOTATION_NAME);
        }
        if (Strings.isNullOrEmpty((String)metadata.getPreferenceKey())) {
            throw new ValidationException("Method(%s) annotated with @%s can not allow to use an empty key", methodName, ANNOTATION_NAME);
        }
    }
}

