/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.validation;

import android.annotation.SuppressLint;
import io.t28.shade.annotation.Preferences;
import io.t28.shade.processor.metadata.ConverterClassMetadata;
import io.t28.shade.processor.metadata.PreferenceClassMetadata;
import io.t28.shade.processor.metadata.PropertyMethodMetadata;
import io.t28.shade.processor.validation.ValidationException;
import io.t28.shade.processor.validation.Validator;
import javax.annotation.Nonnull;
import javax.inject.Inject;

@SuppressLint(value={"NewApi"})
public class PreferenceClassValidator
implements Validator<PreferenceClassMetadata> {
    private static final String ANNOTATION_NAME = Preferences.class.getSimpleName();
    private final Validator<PropertyMethodMetadata> propertyMethodValidator;
    private final Validator<ConverterClassMetadata> converterClassValidator;

    @Inject
    public PreferenceClassValidator(@Nonnull Validator<PropertyMethodMetadata> propertyMethodValidator, @Nonnull Validator<ConverterClassMetadata> converterClassValidator) {
        this.propertyMethodValidator = propertyMethodValidator;
        this.converterClassValidator = converterClassValidator;
    }

    @Override
    public void validate(@Nonnull PreferenceClassMetadata metadata) throws ValidationException {
        if (!metadata.isClass() && !metadata.isInterface()) {
            throw new ValidationException("@%s must not be used for enum", ANNOTATION_NAME);
        }
        String className = metadata.getSimpleName();
        if (!metadata.isAbstract()) {
            throw new ValidationException("Class(%s) annotated with @%s must be an abstract class or interface", className, ANNOTATION_NAME);
        }
        if (!metadata.hasDefaultConstructor()) {
            throw new ValidationException("Class(%s) annotated with @%s must provide a default constructor", className, ANNOTATION_NAME);
        }
        metadata.getPropertyMethods().forEach(property -> {
            this.propertyMethodValidator.validate((PropertyMethodMetadata)property);
            this.converterClassValidator.validate(property.getConverterClass());
        });
    }
}

