/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.validation;

import com.squareup.javapoet.TypeName;
import io.t28.shade.processor.metadata.ConverterClassMetadata;
import io.t28.shade.processor.util.SupportedType;
import io.t28.shade.processor.validation.ValidationException;
import io.t28.shade.processor.validation.Validator;
import javax.annotation.Nonnull;

public class ConverterClassValidator
implements Validator<ConverterClassMetadata> {
    @Override
    public void validate(@Nonnull ConverterClassMetadata metadata) throws ValidationException {
        if (metadata.isDefault()) {
            return;
        }
        if (metadata.isAbstract()) {
            throw new ValidationException("Converter class(%s) must not be an abstract class or interface", metadata.getSimpleName());
        }
        if (!metadata.hasDefaultConstructor()) {
            throw new ValidationException("Converter class(%s) must provide a default constructor", metadata.getSimpleName());
        }
        TypeName storeType = metadata.getSupportedType();
        if (!SupportedType.contains(storeType)) {
            throw new ValidationException("Type(%s) is not allowed to store the SharedPreferences", storeType);
        }
    }
}

