/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.util;

import android.annotation.SuppressLint;
import com.squareup.javapoet.TypeName;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@SuppressLint(value={"NewApi"})
public class TypeElements {
    private TypeElements() {
    }

    @Nonnull
    public static TypeElement toElement(@Nonnull TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            throw new IllegalArgumentException("Kind of type(" + type + ") must be " + (Object)((Object)TypeKind.DECLARED));
        }
        DeclaredType declaredType = (DeclaredType)type;
        Element element = declaredType.asElement();
        if (!(element instanceof TypeElement)) {
            throw new IllegalArgumentException("Provided element(" + element + ") is not instance of TypeElement");
        }
        return (TypeElement)element;
    }

    @Nonnull
    public static List<TypeName> findGenericTypes(@Nonnull TypeElement element, @Nonnull String className) {
        TypeElement currentElement = element;
        while (currentElement != null) {
            for (TypeMirror typeMirror : currentElement.getInterfaces()) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                TypeElement interfaceElement = TypeElements.toElement(declaredType);
                if (interfaceElement.getSimpleName().toString().equals(className)) {
                    return declaredType.getTypeArguments().stream().map(TypeName::get).collect(Collectors.toList());
                }
                List<TypeName> found = TypeElements.findGenericTypes(interfaceElement, className);
                if (found.isEmpty()) continue;
                return found;
            }
            TypeMirror superClassType = currentElement.getSuperclass();
            if (superClassType.getKind() == TypeKind.DECLARED) {
                currentElement = TypeElements.toElement(superClassType);
                continue;
            }
            currentElement = null;
        }
        return Collections.emptyList();
    }
}

