/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.util;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressLint(value={"NewApi"})
public enum SupportedType {
    BOOLEAN(TypeName.BOOLEAN){
        private static final boolean DEFAULT = false;

        @Override
        @Nonnull
        public CodeBlock buildLoadStatement(@Nonnull String variable, @Nonnull String key, @Nullable String defValue) {
            return CodeBlock.builder().add("$N.getBoolean($S, $L)", new Object[]{variable, key, Optional.ofNullable(defValue).map(Boolean::valueOf).orElse(false)}).build();
        }

        @Override
        @NonNull
        public CodeBlock buildSaveStatement(@Nonnull String variable, @Nonnull String key, @Nonnull CodeBlock value) {
            return CodeBlock.builder().add("$N.putBoolean($S, $L)", new Object[]{variable, key, value}).build();
        }
    }
    ,
    FLOAT(TypeName.FLOAT){
        private static final float DEFAULT = 0.0f;

        @Override
        @Nonnull
        public CodeBlock buildLoadStatement(@Nonnull String variable, @Nonnull String key, @Nullable String defValue) {
            return CodeBlock.builder().add("$N.getFloat($S, $Lf)", new Object[]{variable, key, Optional.ofNullable(defValue).map(Float::valueOf).orElse(Float.valueOf(0.0f))}).build();
        }

        @Override
        @NonNull
        public CodeBlock buildSaveStatement(@Nonnull String variable, @Nonnull String key, @Nonnull CodeBlock value) {
            return CodeBlock.builder().add("$N.putFloat($S, $L)", new Object[]{variable, key, value}).build();
        }
    }
    ,
    INT(TypeName.INT){
        private static final int DEFAULT = 0;

        @Override
        @Nonnull
        public CodeBlock buildLoadStatement(@Nonnull String variable, @Nonnull String key, @Nullable String defValue) {
            return CodeBlock.builder().add("$N.getInt($S, $L)", new Object[]{variable, key, Optional.ofNullable(defValue).map(Integer::valueOf).orElse(0)}).build();
        }

        @Override
        @NonNull
        public CodeBlock buildSaveStatement(@Nonnull String variable, @Nonnull String key, @Nonnull CodeBlock value) {
            return CodeBlock.builder().add("$N.putInt($S, $L)", new Object[]{variable, key, value}).build();
        }
    }
    ,
    LONG(TypeName.LONG){
        private static final long DEFAULT = 0L;

        @Override
        @Nonnull
        public CodeBlock buildLoadStatement(@Nonnull String variable, @Nonnull String key, @Nullable String defValue) {
            return CodeBlock.builder().add("$N.getLong($S, $LL)", new Object[]{variable, key, Optional.ofNullable(defValue).map(Long::valueOf).orElse(0L)}).build();
        }

        @Override
        @NonNull
        public CodeBlock buildSaveStatement(@Nonnull String variable, @Nonnull String key, @Nonnull CodeBlock value) {
            return CodeBlock.builder().add("$N.putLong($S, $L)", new Object[]{variable, key, value}).build();
        }
    }
    ,
    STRING((TypeName)ClassName.get(String.class)){
        private static final String DEFAULT = "";

        @Override
        @Nonnull
        public CodeBlock buildLoadStatement(@Nonnull String variable, @Nonnull String key, @Nullable String defValue) {
            return CodeBlock.builder().add("$N.getString($S, $S)", new Object[]{variable, key, Optional.ofNullable(defValue).orElse(DEFAULT)}).build();
        }

        @Override
        @NonNull
        public CodeBlock buildSaveStatement(@Nonnull String variable, @Nonnull String key, @Nonnull CodeBlock value) {
            return CodeBlock.builder().add("$N.putString($S, $L)", new Object[]{variable, key, value}).build();
        }
    }
    ,
    STRING_SET((TypeName)ParameterizedTypeName.get(Set.class, (Type[])new Type[]{String.class})){

        @Override
        @Nonnull
        public CodeBlock buildLoadStatement(@Nonnull String variable, @Nonnull String key, @Nullable String defValue) {
            return CodeBlock.builder().add("$N.getStringSet($S, $L)", new Object[]{variable, key, CodeBlock.builder().add("$T.<$T>emptySet()", new Object[]{Collections.class, String.class}).build()}).build();
        }

        @Override
        @NonNull
        public CodeBlock buildSaveStatement(@Nonnull String variable, @Nonnull String key, @Nonnull CodeBlock value) {
            return CodeBlock.builder().add("$N.putStringSet($S, $L)", new Object[]{variable, key, value}).build();
        }
    };

    private final TypeName type;

    private SupportedType(TypeName type) {
        this.type = type;
    }

    @Nonnull
    public static SupportedType find(@Nonnull TypeName type) {
        return Stream.of(SupportedType.values()).filter(supported -> supported.type.equals((Object)type)).findFirst().orElseThrow(() -> new IllegalArgumentException("Type(" + type + ") is not supported by SharedPreferences"));
    }

    public static boolean contains(@Nonnull TypeName type) {
        try {
            SupportedType.find(type);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Nonnull
    public abstract CodeBlock buildLoadStatement(@Nonnull String var1, @Nonnull String var2, @Nullable String var3);

    @NonNull
    public abstract CodeBlock buildSaveStatement(@Nonnull String var1, @Nonnull String var2, @Nonnull CodeBlock var3);
}

