/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.util;

import com.google.common.annotations.VisibleForTesting;
import io.t28.shade.processor.util.Logger;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.tools.Diagnostic;

public class MessagerLogger
implements Logger {
    private final Messager messager;
    private final Locale locale;

    @Inject
    public MessagerLogger(@Nonnull Messager messager) {
        this(messager, Locale.getDefault());
    }

    @VisibleForTesting
    MessagerLogger(@Nonnull Messager messager, @Nonnull Locale locale) {
        this.messager = messager;
        this.locale = locale;
    }

    @Override
    public void warning(@Nonnull String message, Object ... args) {
        this.print(Diagnostic.Kind.WARNING, message, args);
    }

    @Override
    public void error(@Nonnull String message, Object ... args) {
        this.print(Diagnostic.Kind.ERROR, message, args);
    }

    private void print(Diagnostic.Kind kind, String message, Object ... args) {
        this.messager.printMessage(kind, String.format(this.locale, message, args));
    }
}

