/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.util;

import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.CodeBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class CodeBlocks {
    private CodeBlocks() {
    }

    @Nonnull
    public static CodeBlock createUnmodifiableStatement(@Nonnull TypeMirror type, @Nonnull String variable) {
        if (type.getKind() == TypeKind.ARRAY) {
            return CodeBlock.of((String)"$T.copyOf($N, $N.length)", (Object[])new Object[]{Arrays.class, variable, variable});
        }
        if (MoreTypes.isTypeOf(List.class, (TypeMirror)type)) {
            return CodeBlock.of((String)"new $T<>($N)", (Object[])new Object[]{ArrayList.class, variable});
        }
        if (MoreTypes.isTypeOf(Set.class, (TypeMirror)type)) {
            return CodeBlock.of((String)"new $T<>($N)", (Object[])new Object[]{HashSet.class, variable});
        }
        if (MoreTypes.isTypeOf(Map.class, (TypeMirror)type)) {
            return CodeBlock.of((String)"new $T<>($N)", (Object[])new Object[]{HashMap.class, variable});
        }
        return CodeBlock.of((String)"$N", (Object[])new Object[]{variable});
    }
}

