/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.metadata;

import android.annotation.SuppressLint;
import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import io.t28.shade.annotation.Property;
import io.t28.shade.converter.Converter;
import io.t28.shade.processor.metadata.ConverterClassMetadata;
import io.t28.shade.processor.metadata.MethodMetadata;
import io.t28.shade.processor.util.TypeElements;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.util.Elements;

@SuppressLint(value={"NewApi"})
public class PropertyMethodMetadata
extends MethodMetadata {
    private static final int SIMPLE_NAME_GROUP = 2;
    private static final Pattern GETTER_PATTERN = Pattern.compile("^(get|is|has)?([^a-z].+)");
    private final Property annotation;
    private final Elements elementUtils;

    PropertyMethodMetadata(@Nonnull ExecutableElement element, @Nonnull Property annotation, @Nonnull Elements elementUtils) {
        super(element);
        this.annotation = annotation;
        this.elementUtils = elementUtils;
    }

    @Nonnull
    public String getSimpleNameWithoutPrefix(@Nonnull CaseFormat format) {
        String name = this.getSimpleName();
        Matcher matcher = GETTER_PATTERN.matcher(name);
        if (matcher.matches()) {
            return CaseFormat.UPPER_CAMEL.to(format, matcher.group(2));
        }
        return CaseFormat.LOWER_CAMEL.to(format, this.getSimpleName());
    }

    @Nonnull
    public String getPreferenceKey() {
        if (Strings.isNullOrEmpty((String)this.annotation.value())) {
            return this.annotation.key();
        }
        return this.annotation.value();
    }

    @Nonnull
    public Optional<String> getDefaultValue() {
        return Optional.of(this.annotation.defValue()).filter(value -> !value.isEmpty());
    }

    @Nonnull
    public ConverterClassMetadata getConverterClass() {
        try {
            Class<? extends Converter> converterClass = this.annotation.converter();
            String canonicalName = converterClass.getCanonicalName();
            TypeElement element = this.elementUtils.getTypeElement(canonicalName);
            return new ConverterClassMetadata(element);
        }
        catch (MirroredTypeException e) {
            TypeElement element = TypeElements.toElement(e.getTypeMirror());
            return new ConverterClassMetadata(element);
        }
    }
}

