/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.metadata;

import android.annotation.SuppressLint;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.t28.shade.annotation.Preferences;
import io.t28.shade.annotation.Property;
import io.t28.shade.processor.metadata.ClassMetadata;
import io.t28.shade.processor.metadata.PropertyMethodMetadata;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

@SuppressLint(value={"NewApi"})
public class PreferenceClassMetadata
extends ClassMetadata {
    private final Preferences annotation;
    private final Elements elementUtils;

    @Inject
    public PreferenceClassMetadata(@Nonnull TypeElement element, @Nonnull Elements elementUtils) {
        this(element, element.getAnnotation(Preferences.class), elementUtils);
    }

    @VisibleForTesting
    PreferenceClassMetadata(@Nonnull TypeElement element, @Nonnull Preferences annotation, @Nonnull Elements elementUtils) {
        super(element);
        this.annotation = annotation;
        this.elementUtils = elementUtils;
    }

    public boolean isDefault() {
        return Strings.isNullOrEmpty((String)this.annotation.value()) && Strings.isNullOrEmpty((String)this.annotation.name());
    }

    @Nonnull
    public String getPreferenceName() {
        if (Strings.isNullOrEmpty((String)this.annotation.value())) {
            return this.annotation.name();
        }
        return this.annotation.value();
    }

    public int getOperationMode() {
        return this.annotation.mode();
    }

    @Nonnull
    public List<PropertyMethodMetadata> getPropertyMethods() {
        return this.getMethods().stream().filter(method -> method.getAnnotation(Property.class) != null).map(method -> new PropertyMethodMetadata((ExecutableElement)method, method.getAnnotation(Property.class), this.elementUtils)).collect(Collectors.toList());
    }
}

