/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.metadata;

import android.annotation.SuppressLint;
import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

@SuppressLint(value={"NewApi"})
public class ClassMetadata {
    private final TypeElement element;
    private final List<ExecutableElement> constructors;
    private final List<ExecutableElement> methods;

    ClassMetadata(@Nonnull TypeElement element) {
        this.element = element;
        this.constructors = element.getEnclosedElements().stream().filter(enclosed -> enclosed.getKind() == ElementKind.CONSTRUCTOR).map(ExecutableElement.class::cast).collect(Collectors.toList());
        this.methods = element.getEnclosedElements().stream().filter(enclosed -> enclosed.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).collect(Collectors.toList());
    }

    @Nonnull
    public String getSimpleName() {
        return this.element.getSimpleName().toString();
    }

    @Nonnull
    public ClassName getClassName() {
        return ClassName.get((TypeElement)this.element);
    }

    public boolean isAbstract() {
        return this.element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isClass() {
        return this.element.getKind() == ElementKind.CLASS;
    }

    public boolean isInterface() {
        return this.element.getKind() == ElementKind.INTERFACE;
    }

    public boolean hasDefaultConstructor() {
        if (this.constructors.isEmpty()) {
            return true;
        }
        return this.constructors.stream().anyMatch(constructor -> {
            Set<Modifier> modifiers = constructor.getModifiers();
            if (!modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.ABSTRACT)) {
                return false;
            }
            return constructor.getParameters().isEmpty();
        });
    }

    @Nonnull
    protected List<ExecutableElement> getMethods() {
        return new ArrayList<ExecutableElement>(this.methods);
    }
}

