/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.inject;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.squareup.javapoet.ClassName;
import io.t28.shade.processor.factory.EditorClassFactory;
import io.t28.shade.processor.factory.ModelClassFactory;
import io.t28.shade.processor.factory.PreferenceClassFactory;
import io.t28.shade.processor.factory.TypeFactory;
import io.t28.shade.processor.metadata.ConverterClassMetadata;
import io.t28.shade.processor.metadata.PreferenceClassMetadata;
import io.t28.shade.processor.metadata.PropertyMethodMetadata;
import io.t28.shade.processor.validation.ConverterClassValidator;
import io.t28.shade.processor.validation.PreferenceClassValidator;
import io.t28.shade.processor.validation.PropertyMethodValidator;
import io.t28.shade.processor.validation.Validator;
import java.lang.annotation.Annotation;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class PreferenceModule
implements Module {
    private static final String PREFERENCE_SUFFIX = "Preferences";
    private static final String MODEL_IMPL_SUFFIX = "Impl";
    private static final String EDITOR_CLASS_NAME = "Editor";
    private final TypeElement element;

    public PreferenceModule(@Nonnull TypeElement element) {
        this.element = element;
    }

    public void configure(@Nonnull Binder binder) {
        binder.bind(TypeFactory.class).annotatedWith((Annotation)Names.named((String)PREFERENCE_SUFFIX)).to(PreferenceClassFactory.class);
        binder.bind(TypeFactory.class).annotatedWith((Annotation)Names.named((String)"Model")).to(ModelClassFactory.class);
        binder.bind(TypeFactory.class).annotatedWith((Annotation)Names.named((String)EDITOR_CLASS_NAME)).to(EditorClassFactory.class);
        binder.bind((TypeLiteral)new TypeLiteral<Validator<PreferenceClassMetadata>>(){}).to(PreferenceClassValidator.class);
        binder.bind((TypeLiteral)new TypeLiteral<Validator<PropertyMethodMetadata>>(){}).to(PropertyMethodValidator.class);
        binder.bind((TypeLiteral)new TypeLiteral<Validator<ConverterClassMetadata>>(){}).to(ConverterClassValidator.class);
    }

    @Nonnull
    @Provides
    public TypeElement provideElement() {
        return this.element;
    }

    @Nonnull
    @Provides
    @Named(value="PackageName")
    public String providePackageName(@Nonnull Elements elements) {
        PackageElement packageElement = elements.getPackageOf(this.element);
        return packageElement.getQualifiedName().toString();
    }

    @Nonnull
    @Provides
    @Named(value="Preferences")
    public ClassName providePreferenceClass(@Nonnull @Named(value="PackageName") String packageName) {
        return ClassName.get((String)packageName, (String)(this.element.getSimpleName() + PREFERENCE_SUFFIX), (String[])new String[0]);
    }

    @Nonnull
    @Provides
    @Named(value="Model")
    public ClassName provideModelClass(@Nonnull TypeElement element, @Nonnull @Named(value="PackageName") String packageName) {
        return ClassName.get((String)packageName, (String)element.getSimpleName().toString(), (String[])new String[0]);
    }

    @Nonnull
    @Provides
    @Named(value="ModelImpl")
    public ClassName provideModelImplClass(@Nonnull TypeElement element) {
        return ClassName.bestGuess((String)(element.getSimpleName().toString() + MODEL_IMPL_SUFFIX));
    }

    @Nonnull
    @Provides
    @Named(value="Editor")
    public ClassName provideEditorClass() {
        return ClassName.bestGuess((String)EDITOR_CLASS_NAME);
    }
}

