/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.factory;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.t28.shade.processor.factory.Factory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.lang.model.element.Modifier;

public abstract class TypeFactory
implements Factory<TypeSpec> {
    @Nonnull
    protected abstract String getName();

    @Nonnull
    protected List<AnnotationSpec> getAnnotations() {
        return Collections.emptyList();
    }

    @Nonnull
    protected List<Modifier> getModifiers() {
        return Collections.emptyList();
    }

    @Nonnull
    protected Optional<TypeName> getSuperClass() {
        return Optional.empty();
    }

    @Nonnull
    protected List<TypeName> getInterfaces() {
        return Collections.emptyList();
    }

    @Nonnull
    protected List<FieldSpec> getFields() {
        return Collections.emptyList();
    }

    @Nonnull
    protected List<MethodSpec> getMethods() {
        return Collections.emptyList();
    }

    @Nonnull
    protected List<TypeSpec> getEnclosedTypes() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public TypeSpec create() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.getName());
        builder.addAnnotations(this.getAnnotations());
        this.getModifiers().forEach(xva$0 -> builder.addModifiers(new Modifier[]{xva$0}));
        this.getSuperClass().ifPresent(arg_0 -> ((TypeSpec.Builder)builder).superclass(arg_0));
        this.getInterfaces().forEach(arg_0 -> ((TypeSpec.Builder)builder).addSuperinterface(arg_0));
        builder.addFields(this.getFields());
        this.getMethods().forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        this.getEnclosedTypes().forEach(arg_0 -> ((TypeSpec.Builder)builder).addType(arg_0));
        return builder.build();
    }
}

