/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.factory;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.t28.shade.processor.factory.TypeFactory;
import io.t28.shade.processor.metadata.ConverterClassMetadata;
import io.t28.shade.processor.metadata.PreferenceClassMetadata;
import io.t28.shade.processor.util.SupportedType;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.lang.model.element.Modifier;

public class PreferenceClassFactory
extends TypeFactory {
    private static final String PARAMETER_CONTEXT = "context";
    private static final String FIELD_PREFERENCES = "preferences";
    private static final String METHOD_PREFIX_GET = "get";
    private static final String METHOD_PREFIX_HAS = "contains";
    private final PreferenceClassMetadata preference;
    private final ClassName modelClass;
    private final ClassName modelImplClass;
    private final ClassName editorClass;
    private final ClassName preferencesClass;
    private final List<TypeFactory> enclosedClassFactories;

    @Inject
    public PreferenceClassFactory(@Nonnull PreferenceClassMetadata preference, @Nonnull @Named(value="Model") ClassName modelClass, @Nonnull @Named(value="ModelImpl") ClassName modelImplClass, @Nonnull @Named(value="Editor") ClassName editorClass, @Nonnull @Named(value="Preferences") ClassName preferencesClass, @Nonnull @Named(value="Model") TypeFactory modelClassFactory, @Nonnull @Named(value="Editor") TypeFactory editorClassFactory) {
        this.preference = preference;
        this.modelClass = modelClass;
        this.modelImplClass = modelImplClass;
        this.editorClass = editorClass;
        this.preferencesClass = preferencesClass;
        this.enclosedClassFactories = ImmutableList.of((Object)modelClassFactory, (Object)editorClassFactory);
    }

    @Override
    @Nonnull
    protected String getName() {
        return this.preferencesClass.simpleName();
    }

    @Override
    @Nonnull
    protected List<AnnotationSpec> getAnnotations() {
        return ImmutableList.of((Object)AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"all"}).build());
    }

    @Override
    @Nonnull
    protected List<Modifier> getModifiers() {
        return ImmutableList.of((Object)((Object)Modifier.PUBLIC));
    }

    @Override
    @Nonnull
    protected List<FieldSpec> getFields() {
        return ImmutableList.of((Object)FieldSpec.builder(SharedPreferences.class, (String)FIELD_PREFERENCES, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
    }

    @Override
    @Nonnull
    protected List<MethodSpec> getMethods() {
        return ImmutableList.builder().add((Object)this.buildConstructorSpec()).add((Object)this.buildGetMethodSpec()).addAll(this.buildGetMethodSpecs()).addAll(this.buildContainsMethodSpecs()).add((Object)this.buildEditMethodSpec()).add((Object)this.buildGetSharedPreferencesMethodSpec()).build();
    }

    @Override
    @Nonnull
    protected List<TypeSpec> getEnclosedTypes() {
        return this.enclosedClassFactories.stream().map(TypeFactory::create).collect(Collectors.toList());
    }

    private MethodSpec buildConstructorSpec() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(Context.class, (String)PARAMETER_CONTEXT, (Modifier[])new Modifier[0]).addAnnotation(NonNull.class).build());
        if (this.preference.isDefault()) {
            builder.addStatement("this.$N = $T.getDefaultSharedPreferences($L.getApplicationContext())", new Object[]{FIELD_PREFERENCES, PreferenceManager.class, PARAMETER_CONTEXT});
        } else {
            builder.addStatement("this.$N = $L.getApplicationContext().getSharedPreferences($S, $L)", new Object[]{FIELD_PREFERENCES, PARAMETER_CONTEXT, this.preference.getPreferenceName(), this.preference.getOperationMode()});
        }
        return builder.build();
    }

    private MethodSpec buildGetMethodSpec() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)METHOD_PREFIX_GET).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NonNull.class).returns((TypeName)this.modelClass);
        String arguments = this.preference.getPropertyMethods().stream().map(property -> METHOD_PREFIX_GET + property.getSimpleNameWithoutPrefix(CaseFormat.UPPER_CAMEL) + "()").collect(Collectors.joining(", "));
        builder.addStatement("return new $T($L)", new Object[]{this.modelImplClass, arguments});
        return builder.build();
    }

    private List<MethodSpec> buildGetMethodSpecs() {
        return this.preference.getPropertyMethods().stream().map(property -> {
            String methodName = METHOD_PREFIX_GET + property.getSimpleNameWithoutPrefix(CaseFormat.UPPER_CAMEL);
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC});
            TypeName returnType = property.getReturnTypeName();
            if (!returnType.isPrimitive()) {
                builder.addAnnotation(NonNull.class);
            }
            builder.returns(returnType);
            ConverterClassMetadata converter = property.getConverterClass();
            TypeName valueType = converter.isDefault() ? property.getReturnTypeName() : converter.getSupportedType();
            SupportedType supported = SupportedType.find(valueType);
            CodeBlock statement = supported.buildLoadStatement(FIELD_PREFERENCES, property.getPreferenceKey(), property.getDefaultValue().orElse(null));
            if (converter.isDefault()) {
                builder.addStatement("return $L", new Object[]{statement});
            } else {
                builder.addStatement("return new $T().toConverted($L)", new Object[]{converter.getClassName(), statement});
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    private List<MethodSpec> buildContainsMethodSpecs() {
        return this.preference.getPropertyMethods().stream().map(property -> {
            String methodName = METHOD_PREFIX_HAS + property.getSimpleNameWithoutPrefix(CaseFormat.UPPER_CAMEL);
            return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addStatement("return $L.contains($S)", new Object[]{FIELD_PREFERENCES, property.getPreferenceKey()}).build();
        }).collect(Collectors.toList());
    }

    private MethodSpec buildEditMethodSpec() {
        return MethodSpec.methodBuilder((String)"edit").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(NonNull.class).returns((TypeName)this.editorClass).addStatement("return new $L($N)", new Object[]{this.editorClass, FIELD_PREFERENCES}).build();
    }

    private MethodSpec buildGetSharedPreferencesMethodSpec() {
        return MethodSpec.methodBuilder((String)"getSharedPreferences").addAnnotation(NonNull.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(SharedPreferences.class).addStatement("return $L", new Object[]{FIELD_PREFERENCES}).build();
    }
}

