/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.factory;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import io.t28.shade.internal.EqualsBuilder;
import io.t28.shade.internal.HashCodeBuilder;
import io.t28.shade.internal.ToStringBuilder;
import io.t28.shade.processor.factory.TypeFactory;
import io.t28.shade.processor.metadata.PreferenceClassMetadata;
import io.t28.shade.processor.metadata.PropertyMethodMetadata;
import io.t28.shade.processor.util.CodeBlocks;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

@SuppressLint(value={"NewApi"})
public class ModelClassFactory
extends TypeFactory {
    private static final String METHOD_NAME_EQUALS = "equals";
    private static final String METHOD_NAME_HASH_CODE = "hashCode";
    private static final String METHOD_NAME_TO_STRING = "toString";
    private final PreferenceClassMetadata preference;
    private final List<PropertyMethodMetadata> properties;
    private final ClassName modelClass;
    private final ClassName modelImplClass;

    @Inject
    public ModelClassFactory(@Nonnull PreferenceClassMetadata preference, @Nonnull @Named(value="Model") ClassName modelClass, @Nonnull @Named(value="ModelImpl") ClassName modelImplClass) {
        this.preference = preference;
        this.properties = preference.getPropertyMethods();
        this.modelClass = modelClass;
        this.modelImplClass = modelImplClass;
    }

    @Override
    @Nonnull
    protected String getName() {
        return this.modelImplClass.simpleName();
    }

    @Override
    @Nonnull
    protected List<Modifier> getModifiers() {
        return ImmutableList.of((Object)((Object)Modifier.PUBLIC), (Object)((Object)Modifier.STATIC));
    }

    @Override
    @Nonnull
    protected Optional<TypeName> getSuperClass() {
        if (this.preference.isClass()) {
            return Optional.of(this.modelClass);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    protected List<TypeName> getInterfaces() {
        if (this.preference.isInterface()) {
            return Collections.singletonList(this.modelClass);
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    protected List<FieldSpec> getFields() {
        return ImmutableList.copyOf((Collection)this.properties.stream().map(property -> {
            String fieldName = property.getSimpleNameWithoutPrefix(CaseFormat.LOWER_CAMEL);
            TypeName valueType = property.getReturnTypeName();
            return FieldSpec.builder((TypeName)valueType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    protected List<MethodSpec> getMethods() {
        return ImmutableList.builder().add((Object)this.buildConstructorSpec()).add((Object)this.buildEqualsMethodSpec()).add((Object)this.buildHashCodeMethodSpec()).add((Object)this.buildToStringMethodSpec()).addAll(this.buildGetMethodSpecs()).build();
    }

    private MethodSpec buildConstructorSpec() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.properties.forEach(property -> {
            TypeName valueType = property.getReturnTypeName();
            String fieldName = property.getSimpleNameWithoutPrefix(CaseFormat.LOWER_CAMEL);
            ParameterSpec parameter = valueType.isPrimitive() ? ParameterSpec.builder((TypeName)valueType, (String)fieldName, (Modifier[])new Modifier[0]).build() : ParameterSpec.builder((TypeName)valueType, (String)fieldName, (Modifier[])new Modifier[0]).addAnnotation(NonNull.class).build();
            builder.addParameter(parameter);
        });
        this.properties.forEach(property -> {
            TypeMirror valueType = property.getReturnType();
            String fieldName = property.getSimpleNameWithoutPrefix(CaseFormat.LOWER_CAMEL);
            builder.addStatement("$L", new Object[]{CodeBlock.builder().add("this.$L = $L", new Object[]{fieldName, CodeBlocks.createUnmodifiableStatement(valueType, fieldName)}).build()});
        });
        return builder.build();
    }

    private MethodSpec buildToStringMethodSpec() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)METHOD_NAME_TO_STRING).addAnnotation(NonNull.class).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        builder.addStatement("final $1T builder = new $1T(this)", new Object[]{ToStringBuilder.class});
        this.properties.forEach(property -> {
            String fieldName = property.getSimpleNameWithoutPrefix(CaseFormat.LOWER_CAMEL);
            builder.addStatement("builder.append($1S, $1L)", new Object[]{fieldName});
        });
        builder.addStatement("return builder.toString()", new Object[0]);
        return builder.build();
    }

    private MethodSpec buildEqualsMethodSpec() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)METHOD_NAME_EQUALS).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, "object", new Modifier[0]);
        builder.beginControlFlow("if (this == object)", new Object[0]).addStatement("return true", new Object[0]).endControlFlow();
        builder.beginControlFlow("if (!(object instanceof $T))", new Object[]{this.modelClass}).addStatement("return false", new Object[0]).endControlFlow();
        builder.addStatement("final $T that = ($T) object", new Object[]{this.modelClass, this.modelClass});
        builder.addStatement("final $1T builder = new $1T()", new Object[]{EqualsBuilder.class});
        this.properties.forEach(property -> {
            String fieldName = property.getSimpleNameWithoutPrefix(CaseFormat.LOWER_CAMEL);
            String methodName = property.getSimpleName();
            builder.addStatement("builder.append($L, that.$L())", new Object[]{fieldName, methodName});
        });
        builder.addStatement("return builder.build()", new Object[0]);
        return builder.build();
    }

    private MethodSpec buildHashCodeMethodSpec() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)METHOD_NAME_HASH_CODE).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE);
        builder.addStatement("final $1T builder = new $1T()", new Object[]{HashCodeBuilder.class});
        this.properties.forEach(property -> {
            String fieldName = property.getSimpleNameWithoutPrefix(CaseFormat.LOWER_CAMEL);
            builder.addStatement("builder.append($L)", new Object[]{fieldName});
        });
        builder.addStatement("return builder.build()", new Object[0]);
        return builder.build();
    }

    private List<MethodSpec> buildGetMethodSpecs() {
        return this.properties.stream().map(property -> {
            String fieldName = property.getSimpleNameWithoutPrefix(CaseFormat.LOWER_CAMEL);
            TypeMirror valueType = property.getReturnType();
            CodeBlock statement = CodeBlocks.createUnmodifiableStatement(valueType, fieldName);
            return MethodSpec.overriding((ExecutableElement)property.getMethod()).addStatement("return $L", new Object[]{statement}).build();
        }).collect(Collectors.toList());
    }
}

