/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor.factory;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import io.t28.shade.processor.factory.TypeFactory;
import io.t28.shade.processor.metadata.ConverterClassMetadata;
import io.t28.shade.processor.metadata.PreferenceClassMetadata;
import io.t28.shade.processor.metadata.PropertyMethodMetadata;
import io.t28.shade.processor.util.SupportedType;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.lang.model.element.Modifier;

public class EditorClassFactory
extends TypeFactory {
    private static final String FIELD_EDITOR = "editor";
    private static final String METHOD_PREFIX_PUT = "put";
    private static final String METHOD_PREFIX_REMOVE = "remove";
    private final List<PropertyMethodMetadata> properties;
    private final ClassName modelClass;
    private final ClassName editorClass;

    @Inject
    public EditorClassFactory(@Nonnull PreferenceClassMetadata preference, @Nonnull @Named(value="Model") ClassName modelClass, @Nonnull @Named(value="Editor") ClassName editorClass) {
        this(preference.getPropertyMethods(), modelClass, editorClass);
    }

    @VisibleForTesting
    EditorClassFactory(@Nonnull List<PropertyMethodMetadata> properties, @NonNull ClassName modelClass, @Nonnull ClassName editorClass) {
        this.properties = properties;
        this.modelClass = modelClass;
        this.editorClass = editorClass;
    }

    @Override
    @Nonnull
    protected String getName() {
        return this.editorClass.simpleName();
    }

    @Override
    @Nonnull
    protected List<Modifier> getModifiers() {
        return ImmutableList.of((Object)((Object)Modifier.PUBLIC), (Object)((Object)Modifier.STATIC));
    }

    @Override
    @Nonnull
    protected List<FieldSpec> getFields() {
        return ImmutableList.of((Object)FieldSpec.builder(SharedPreferences.Editor.class, (String)FIELD_EDITOR, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
    }

    @Override
    @Nonnull
    protected List<MethodSpec> getMethods() {
        return ImmutableList.builder().add((Object)this.buildConstructorSpec()).add((Object)this.buildPutModelMethodSpec()).addAll(this.buildPutPropertyMethodSpecs()).addAll(this.buildRemoveMethodSpecs()).add((Object)this.buildClearMethodSpec()).add((Object)this.buildApplyMethodSpec()).build();
    }

    private MethodSpec buildConstructorSpec() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(ParameterSpec.builder(SharedPreferences.class, (String)"preferences", (Modifier[])new Modifier[0]).addAnnotation(NonNull.class).build()).addStatement("this.$L = $L", new Object[]{FIELD_EDITOR, "preferences.edit()"}).build();
    }

    private MethodSpec buildPutModelMethodSpec() {
        String parameterName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.modelClass.simpleName());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)METHOD_PREFIX_PUT).addAnnotation(NonNull.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.editorClass).addParameter(ParameterSpec.builder((TypeName)this.modelClass, (String)parameterName, (Modifier[])new Modifier[0]).addAnnotation(NonNull.class).build());
        this.properties.forEach(property -> builder.addStatement("$N$N($N.$N())", new Object[]{METHOD_PREFIX_PUT, property.getSimpleNameWithoutPrefix(CaseFormat.UPPER_CAMEL), parameterName, property.getSimpleName()}));
        builder.addStatement("return this", new Object[0]);
        return builder.build();
    }

    private List<MethodSpec> buildPutPropertyMethodSpecs() {
        return this.properties.stream().map(property -> {
            String methodName = METHOD_PREFIX_PUT + property.getSimpleNameWithoutPrefix(CaseFormat.UPPER_CAMEL);
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addAnnotation(NonNull.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.editorClass);
            String parameterName = property.getSimpleNameWithoutPrefix(CaseFormat.LOWER_CAMEL);
            TypeName valueType = property.getReturnTypeName();
            if (valueType.isPrimitive()) {
                builder.addParameter(ParameterSpec.builder((TypeName)valueType, (String)parameterName, (Modifier[])new Modifier[0]).build());
            } else {
                builder.addParameter(ParameterSpec.builder((TypeName)valueType, (String)parameterName, (Modifier[])new Modifier[0]).addAnnotation(NonNull.class).build());
            }
            ConverterClassMetadata converter = property.getConverterClass();
            TypeName storeType = converter.isDefault() ? property.getReturnTypeName() : converter.getSupportedType();
            SupportedType supportedType = SupportedType.find(storeType);
            return builder.addStatement("$L", new Object[]{this.buildSaveStatement((PropertyMethodMetadata)property, supportedType, parameterName)}).addStatement("return this", new Object[0]).build();
        }).collect(Collectors.toList());
    }

    private List<MethodSpec> buildRemoveMethodSpecs() {
        return this.properties.stream().map(property -> {
            String methodName = METHOD_PREFIX_REMOVE + property.getSimpleNameWithoutPrefix(CaseFormat.UPPER_CAMEL);
            return MethodSpec.methodBuilder((String)methodName).addAnnotation(NonNull.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$L.remove($S)", new Object[]{FIELD_EDITOR, property.getPreferenceKey()}).addStatement("return this", new Object[0]).returns((TypeName)this.editorClass).build();
        }).collect(Collectors.toList());
    }

    private MethodSpec buildClearMethodSpec() {
        return MethodSpec.methodBuilder((String)"clear").addAnnotation(NonNull.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$L.clear()", new Object[]{FIELD_EDITOR}).addStatement("return this", new Object[0]).returns((TypeName)this.editorClass).build();
    }

    private MethodSpec buildApplyMethodSpec() {
        return MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$L.apply()", new Object[]{FIELD_EDITOR}).build();
    }

    private CodeBlock buildSaveStatement(PropertyMethodMetadata property, SupportedType supported, String parameterName) {
        ConverterClassMetadata converter = property.getConverterClass();
        CodeBlock statement = converter.isDefault() ? CodeBlock.builder().add(parameterName, new Object[0]).build() : CodeBlock.builder().add("new $T().toSupported($L)", new Object[]{converter.getClassName(), parameterName}).build();
        return supported.buildSaveStatement(FIELD_EDITOR, property.getPreferenceKey(), statement);
    }
}

