/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.processor;

import android.annotation.SuppressLint;
import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import io.t28.shade.annotation.Preferences;
import io.t28.shade.processor.factory.TypeFactory;
import io.t28.shade.processor.inject.PreferenceModule;
import io.t28.shade.processor.inject.ShadeModule;
import io.t28.shade.processor.metadata.PreferenceClassMetadata;
import io.t28.shade.processor.util.Logger;
import io.t28.shade.processor.validation.ValidationException;
import io.t28.shade.processor.validation.Validator;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;

@AutoService(value=Processor.class)
@SuppressLint(value={"NewApi"})
public class ShadeProcessor
extends AbstractProcessor {
    private static final String INDENT = "    ";
    private static final Key<String> PACKAGE_NAME_KEY = Key.get(String.class, (Annotation)Names.named((String)"PackageName"));
    private static final Key<TypeFactory> TYPE_FACTORY_KEY = Key.get(TypeFactory.class, (Annotation)Names.named((String)"Preferences"));
    private static final Key<Validator<PreferenceClassMetadata>> VALIDATOR_KEY = Key.get((TypeLiteral)new TypeLiteral<Validator<PreferenceClassMetadata>>(){});
    private Injector injector;
    @Inject
    private Logger logger;
    @Inject
    private Filer filer;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)Preferences.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(@Nonnull ProcessingEnvironment environment) {
        super.init(environment);
        this.injector = Guice.createInjector((Module[])new Module[]{new ShadeModule(environment)});
    }

    @Override
    public boolean process(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment environment) {
        this.injector.injectMembers((Object)this);
        environment.getElementsAnnotatedWith(Preferences.class).stream().map(TypeElement.class::cast).forEach(element -> {
            try {
                this.process((TypeElement)element);
            }
            catch (ValidationException e) {
                this.logger.error(e.getMessage(), new Object[0]);
            }
            catch (IOException e) {
                this.logger.warning("Unable to generate a source file: %s", e.getMessage());
            }
            catch (RuntimeException e) {
                this.logger.error("Internal error occurred: %s", Throwables.getStackTraceAsString((Throwable)e));
            }
        });
        return false;
    }

    private void process(@Nonnull TypeElement element) throws ValidationException, IOException {
        Injector childInjector = this.injector.createChildInjector(new Module[]{new PreferenceModule(element)});
        PreferenceClassMetadata preference = (PreferenceClassMetadata)childInjector.getInstance(PreferenceClassMetadata.class);
        Validator validator = (Validator)childInjector.getInstance(VALIDATOR_KEY);
        validator.validate(preference);
        String packageName = (String)childInjector.getInstance(PACKAGE_NAME_KEY);
        TypeFactory factory = (TypeFactory)childInjector.getInstance(TYPE_FACTORY_KEY);
        JavaFile file = JavaFile.builder((String)packageName, (TypeSpec)factory.create()).indent(INDENT).skipJavaLangImports(true).build();
        file.writeTo(this.filer);
    }
}

