/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.internal;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;

public class ToStringBuilder {
    private static final int INITIAL_CAPACITY = 32;
    private final String className;
    private final Map<String, String> values;

    public ToStringBuilder(@NonNull Object object) {
        this(object.getClass().getSimpleName(), new HashMap<String, String>());
    }

    @VisibleForTesting
    ToStringBuilder(@NonNull String className, @NonNull Map<String, String> values) {
        this.className = className;
        this.values = values;
    }

    @NonNull
    public ToStringBuilder append(@NonNull String name, boolean value) {
        this.values.put(name, String.valueOf(value));
        return this;
    }

    @NonNull
    public ToStringBuilder append(@NonNull String name, byte value) {
        this.values.put(name, String.valueOf(value));
        return this;
    }

    @NonNull
    public ToStringBuilder append(@NonNull String name, char value) {
        this.values.put(name, String.valueOf(value));
        return this;
    }

    @NonNull
    public ToStringBuilder append(@NonNull String name, double value) {
        this.values.put(name, String.valueOf(value));
        return this;
    }

    @NonNull
    public ToStringBuilder append(@NonNull String name, float value) {
        this.values.put(name, String.valueOf(value));
        return this;
    }

    @NonNull
    public ToStringBuilder append(@NonNull String name, short value) {
        this.values.put(name, String.valueOf(value));
        return this;
    }

    @NonNull
    public ToStringBuilder append(@NonNull String name, int value) {
        this.values.put(name, String.valueOf(value));
        return this;
    }

    @NonNull
    public ToStringBuilder append(@NonNull String name, long value) {
        this.values.put(name, String.valueOf(value));
        return this;
    }

    @NonNull
    public ToStringBuilder append(@NonNull String name, @Nullable Object value) {
        this.values.put(name, String.valueOf(value));
        return this;
    }

    @NonNull
    @CheckResult
    public String build() {
        StringBuilder builder = new StringBuilder(32);
        builder.append(this.className).append("{");
        String delimiter = "";
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            builder.append(delimiter);
            builder.append(entry.getKey()).append("=").append(entry.getValue());
            delimiter = ", ";
        }
        builder.append("}");
        return builder.toString();
    }
}

