/*
 * Decompiled with CFR 0.152.
 */
package io.t28.shade.internal;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;

public class HashCodeBuilder {
    private static final int DEFAULT_INITIAL_VALUE = 1;
    private static final int DEFAULT_CONSTANT_VALUE = 31;
    private final int constantValue;
    private int hashCode;

    public HashCodeBuilder() {
        this(1, 31);
    }

    @VisibleForTesting
    HashCodeBuilder(int initialValue, int constantValue) {
        this.constantValue = constantValue;
        this.hashCode = initialValue;
    }

    @NonNull
    public HashCodeBuilder append(boolean value) {
        return this.append((Object)value);
    }

    @NonNull
    public HashCodeBuilder append(byte value) {
        return this.append((Object)value);
    }

    @NonNull
    public HashCodeBuilder append(char value) {
        return this.append(Character.valueOf(value));
    }

    @NonNull
    public HashCodeBuilder append(double value) {
        return this.append((Object)value);
    }

    @NonNull
    public HashCodeBuilder append(float value) {
        return this.append(Float.valueOf(value));
    }

    @NonNull
    public HashCodeBuilder append(short value) {
        return this.append((Object)value);
    }

    @NonNull
    public HashCodeBuilder append(int value) {
        return this.append((Object)value);
    }

    @NonNull
    public HashCodeBuilder append(long value) {
        return this.append((Object)value);
    }

    @NonNull
    public HashCodeBuilder append(@Nullable Object value) {
        if (value == null) {
            this.hashCode = this.constantValue * this.hashCode;
            return this;
        }
        this.hashCode = this.constantValue * this.hashCode + value.hashCode();
        return this;
    }

    @CheckResult
    public int build() {
        return this.hashCode;
    }
}

