/*
 * Decompiled with CFR 0.152.
 */
package io.sysl;

import io.sysl.Enumeration;
import io.sysl.Enumerator;
import io.sysl.Expr;
import io.sysl.SyslException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Enumerable<T>
implements Iterable<T> {
    public abstract Enumerator<T> enumerator();

    @Override
    public Iterator<T> iterator() {
        final Enumerator<T> enumerator = this.enumerator();
        return new Iterator<T>(){
            private boolean have;
            {
                this.have = enumerator.moveNext();
            }

            @Override
            public boolean hasNext() {
                return this.have;
            }

            @Override
            public T next() throws NoSuchElementException {
                if (!this.have) {
                    throw new NoSuchElementException();
                }
                Object result = enumerator.current();
                this.have = enumerator.moveNext();
                return result;
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public int size() {
        return this.sizeWithLimit(Integer.MAX_VALUE);
    }

    public Integer count() {
        return this.size();
    }

    public int sizeWithLimit(int limit) {
        int n = 0;
        for (T item : this) {
            if (++n != limit) continue;
            break;
        }
        return n;
    }

    public ArrayList<T> asArrayList() {
        ArrayList<T> result = new ArrayList<T>();
        for (T e : this) {
            result.add(e);
        }
        return result;
    }

    public T singleOrNull() throws RuntimeException {
        T result = null;
        for (T item : this) {
            if (result != null) {
                throw new SyslException("size() == " + this.size() + " > 1");
            }
            result = item;
        }
        return result;
    }

    public T single() throws RuntimeException {
        T result = this.singleOrNull();
        if (result == null) {
            throw new SyslException("size() == " + this.size() + " != 1");
        }
        return result;
    }

    public <U> Enumerable<U> map(Expr<U, T> map) {
        return Enumeration.map(this, map);
    }

    public Enumerable<T> orderBy(Comparator<T> comp) {
        return Enumeration.orderBy(this, comp);
    }

    public <U> U reduce(U u, Reducer<T, U> reducer) {
        for (T t : this) {
            u = reducer.reduce(u, t);
        }
        return u;
    }

    public <U extends Comparable<U>> U min(final Expr<U, T> expr) {
        Iterator<T> iterator = this.iterator();
        if (iterator.hasNext()) {
            T e = iterator.next();
            return (U)((Comparable)this.reduce(expr.evaluate(e), new Reducer<T, U>(){

                @Override
                public U reduce(U i, T t) {
                    Comparable j = (Comparable)expr.evaluate(t);
                    return i.compareTo((Comparable)j) < 0 ? i : j;
                }
            }));
        }
        return null;
    }

    public <U extends Comparable<U>> U max(final Expr<U, T> expr) {
        Iterator<T> iterator = this.iterator();
        if (iterator.hasNext()) {
            T e = iterator.next();
            return (U)((Comparable)this.reduce(expr.evaluate(e), new Reducer<T, U>(){

                @Override
                public U reduce(U i, T t) {
                    Comparable j = (Comparable)expr.evaluate(t);
                    return i.compareTo((Comparable)j) < 0 ? j : i;
                }
            }));
        }
        return null;
    }

    public Integer sumInteger(final Expr<Integer, T> expr) {
        return this.reduce(0, new Reducer<T, Integer>(){

            @Override
            public Integer reduce(Integer i, T t) {
                return i + (Integer)expr.evaluate(t);
            }
        });
    }

    public Double sumDouble(final Expr<Double, T> expr) {
        return this.reduce(0.0, new Reducer<T, Double>(){

            @Override
            public Double reduce(Double i, T t) {
                return i + (Double)expr.evaluate(t);
            }
        });
    }

    public BigDecimal sumBigDecimal(final Expr<BigDecimal, T> expr) {
        return this.reduce(BigDecimal.ZERO, new Reducer<T, BigDecimal>(){

            @Override
            public BigDecimal reduce(BigDecimal i, T t) {
                return i.add((BigDecimal)expr.evaluate(t));
            }
        });
    }

    public static interface Reducer<T, U> {
        public U reduce(U var1, T var2);
    }
}

