/*
 * Decompiled with CFR 0.152.
 */
package io.sysl;

import io.sysl.Enumerable;
import io.sysl.Enumeration;
import io.sysl.Enumerator;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class ModelView {
    private final HashMap<String, Integer> autoincs = new HashMap();
    private final HashMap<String, Pattern> patterns = new HashMap();

    protected int autoinc() {
        return this.autoinc("");
    }

    protected int autoinc(String key) {
        Integer i = this.autoincs.get(key);
        i = i == null ? Integer.valueOf(1) : Integer.valueOf(i + 1);
        this.autoincs.put(key, i);
        return i;
    }

    protected String concat(String[] params) {
        return this.concat(params, "");
    }

    protected String concat(String[] params, String sep) {
        StringBuilder sb = new StringBuilder();
        boolean added = false;
        for (String param : params) {
            if (param == null) continue;
            if (added) {
                sb.append(sep);
            } else {
                added = true;
            }
            sb.append(param);
        }
        return added ? sb.toString() : null;
    }

    private int firstNotOf(String s, String toks) {
        int i;
        int len = s.length();
        for (i = 0; i < len && toks.indexOf(s.charAt(i)) == -1; ++i) {
        }
        return i;
    }

    private int lastNotOf(String s, String toks) {
        int i = s.length();
        while (i-- != 0 && toks.indexOf(s.charAt(i)) == -1) {
        }
        return i;
    }

    protected Boolean log(String fmt, Object ... params) {
        System.out.format(fmt, params);
        return true;
    }

    protected String lstrip(String s, String toks) {
        return s == null ? s : s.substring(this.firstNotOf(s, toks));
    }

    protected String rstrip(String s, String toks) {
        return s == null ? s : s.substring(0, this.lastNotOf(s, toks) + 1);
    }

    protected String strip(String s, String toks) {
        if (s == null) {
            return null;
        }
        int start = this.firstNotOf(s, toks);
        int finish = this.lastNotOf(s, toks) + 1;
        if (finish <= start) {
            return "";
        }
        return s.substring(start, finish);
    }

    protected String regsub(String regex, String replacement, String text) {
        Pattern p = this.patterns.get(regex);
        if (p == null) {
            p = Pattern.compile(regex);
            this.patterns.put(regex, p);
        }
        Matcher m = p.matcher(text);
        return m.replaceAll(replacement);
    }

    protected int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    protected double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    protected BigDecimal clamp(BigDecimal value, BigDecimal min, BigDecimal max) {
        return value.max(min).min(max);
    }

    protected String substr(String s, int start, int end) {
        int len = s.length();
        start = this.clamp(start, 0, len);
        end = this.clamp(end, start, len);
        return s.substring(start, end);
    }

    protected String substr(String s, int start) {
        int len = s.length();
        start = this.clamp(start, 0, len);
        return s.substring(start, len);
    }

    protected DateTime now() {
        return new DateTime();
    }

    protected LocalDate today() {
        return new LocalDate();
    }

    protected LocalDate to_date(DateTime dt) {
        return dt.toLocalDate();
    }

    public static class EmptyTuple {
        public static EmptyTuple theOne = new EmptyTuple();

        private EmptyTuple() {
        }

        public static class View
        extends Enumerable<EmptyTuple> {
            @Override
            public Enumerator<EmptyTuple> enumerator() {
                return Enumeration.empty().enumerator();
            }
        }
    }
}

