/*
 * Decompiled with CFR 0.152.
 */
package io.sysl;

import io.sysl.Enumerable;
import io.sysl.Enumerator;
import io.sysl.Expr;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;

public class Enumeration {
    public static <T> Enumerable<T> enumerable(final Iterable<T> iterable) {
        return new Enumerable<T>(){

            @Override
            public Enumerator<T> enumerator() {
                return Enumeration.enumerator(this.iterator());
            }

            @Override
            public Iterator<T> iterator() {
                return iterable.iterator();
            }
        };
    }

    public static <T> Enumerator<T> enumerator(final Iterator<T> iterator) {
        return new Enumerator<T>(){
            T value;

            @Override
            public boolean moveNext() {
                if (iterator.hasNext()) {
                    this.value = iterator.next();
                    return true;
                }
                return false;
            }

            @Override
            public T current() {
                return this.value;
            }
        };
    }

    public static <T> Enumerable<T> dedup(final Enumerable<T> input) {
        return new Enumerable<T>(){

            @Override
            public Enumerator<T> enumerator() {
                final Enumerator source = input.enumerator();
                return new Enumerator<T>(){
                    private HashSet<T> seen = new HashSet();

                    @Override
                    public boolean moveNext() {
                        while (source.moveNext()) {
                            if (this.seen.contains(this.current())) continue;
                            this.seen.add(this.current());
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public T current() {
                        return source.current();
                    }
                };
            }
        };
    }

    public static <T> Enumerable<T> any(final Enumerable<T> input, final int n) {
        return new Enumerable<T>(){

            @Override
            public Enumerator<T> enumerator() {
                final Enumerator source = input.enumerator();
                return new Enumerator<T>(){
                    private int i;
                    {
                        this.i = n;
                    }

                    @Override
                    public boolean moveNext() {
                        if (this.i != 0 && source.moveNext()) {
                            --this.i;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public T current() {
                        return source.current();
                    }
                };
            }
        };
    }

    public static <T> Enumerable<T> empty() {
        return new Enumerable<T>(){

            @Override
            public Enumerator<T> enumerator() {
                return new Enumerator<T>(){

                    @Override
                    public boolean moveNext() {
                        return false;
                    }

                    @Override
                    public T current() {
                        return null;
                    }
                };
            }
        };
    }

    public static <T> Enumerable<T> where(final Enumerable<T> input, final Expr<Boolean, T> pred) {
        return new Enumerable<T>(){

            @Override
            public Enumerator<T> enumerator() {
                final Enumerator source = input.enumerator();
                return new Enumerator<T>(){

                    @Override
                    public boolean moveNext() {
                        while (source.moveNext()) {
                            if (!((Boolean)pred.evaluate(this.current())).booleanValue()) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public T current() {
                        return source.current();
                    }
                };
            }
        };
    }

    public static <T, U> Enumerable<U> map(final Enumerable<T> input, final Expr<U, T> map) {
        return new Enumerable<U>(){

            @Override
            public Enumerator<U> enumerator() {
                final Enumerator source = input.enumerator();
                return new Enumerator<U>(){
                    private U curr;

                    @Override
                    public boolean moveNext() {
                        if (source.moveNext()) {
                            this.curr = map.evaluate(source.current());
                            return true;
                        }
                        this.curr = null;
                        return false;
                    }

                    @Override
                    public U current() {
                        return this.curr;
                    }
                };
            }
        };
    }

    public static <T, U> Enumerable<U> flatten(final Enumerable<T> input, final Expr<Enumerable<U>, T> nested) {
        return Enumeration.dedup(new Enumerable<U>(){

            @Override
            public Enumerator<U> enumerator() {
                final Enumerator outer = input.enumerator();
                return new Enumerator<U>(){
                    private Enumerator<U> inner = this.nextOuter();

                    @Override
                    public boolean moveNext() {
                        while (this.inner != null && !this.inner.moveNext()) {
                            this.inner = this.nextOuter();
                            if (this.inner != null) continue;
                            return false;
                        }
                        return this.inner != null;
                    }

                    @Override
                    public U current() {
                        return this.inner.current();
                    }

                    private Enumerator<U> nextOuter() {
                        if (outer.moveNext()) {
                            return ((Enumerable)nested.evaluate(outer.current())).enumerator();
                        }
                        return null;
                    }
                };
            }
        });
    }

    public static <T> Enumerable<T> orderBy(final Enumerable<T> input, final Comparator<T> comp) {
        return new Enumerable<T>(){

            @Override
            public Enumerator<T> enumerator() {
                final PriorityQueue pq = new PriorityQueue(11, comp);
                for (Object item : input) {
                    pq.add(item);
                }
                return new Enumerator<T>(){
                    private T item;

                    @Override
                    public boolean moveNext() {
                        this.item = pq.poll();
                        return this.item != null;
                    }

                    @Override
                    public T current() {
                        return this.item;
                    }
                };
            }
        };
    }

    public static <T> Enumerable<T> first(final Enumerable<T> input, final int n, final Comparator<T> comp) {
        return new Enumerable<T>(){

            @Override
            public Enumerator<T> enumerator() {
                PriorityQueue pq = new PriorityQueue(n + 1, Collections.reverseOrder(comp));
                for (Object item : input) {
                    pq.add(item);
                    if (pq.size() != n + 1) continue;
                    pq.poll();
                }
                return Enumeration.enumerator(pq.iterator());
            }
        };
    }

    public static <T, U> Enumerable<U> rank(final Enumerable<T> input, final Ranker<T, U> ranker) {
        return new Enumerable<U>(){

            @Override
            public Enumerator<U> enumerator() {
                final Enumerator source = Enumeration.orderBy(input, ranker).enumerator();
                return new Enumerator<U>(){
                    private T prev_in;
                    private U curr;
                    private int rank = 0;
                    private int count = 0;

                    @Override
                    public boolean moveNext() {
                        if (source.moveNext()) {
                            int r;
                            Object curr_in = source.current();
                            int n = r = this.prev_in == null ? -1 : ranker.compare(this.prev_in, curr_in);
                            assert (r <= 0) : curr_in;
                            if (r != 0) {
                                this.rank = this.count;
                                this.prev_in = curr_in;
                            }
                            ++this.count;
                            this.curr = ranker.ranked(source.current(), this.rank);
                            return true;
                        }
                        this.curr = null;
                        return false;
                    }

                    @Override
                    public U current() {
                        return this.curr;
                    }
                };
            }
        };
    }

    public static interface Ranker<T, R>
    extends Comparator<T> {
        public R ranked(T var1, int var2);
    }
}

