/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.simple;

import com.syncano.library.Syncano;
import com.syncano.library.api.FieldsFilter;
import com.syncano.library.api.RequestCount;
import com.syncano.library.api.RequestGet;
import com.syncano.library.api.RequestGetList;
import com.syncano.library.api.RequestTemplate;
import com.syncano.library.api.Response;
import com.syncano.library.api.ResponseGetList;
import com.syncano.library.api.Where;
import com.syncano.library.callbacks.SyncanoCallback;
import com.syncano.library.choice.FilterType;
import com.syncano.library.choice.SortOrder;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.offline.OfflineFetchRequest;
import com.syncano.library.offline.OfflineGetListRequest;
import com.syncano.library.offline.OfflineMode;
import com.syncano.library.offline.OfflineRequest;
import java.util.List;

public class RequestBuilder<T extends SyncanoObject> {
    private Syncano syncano;
    private Class<T> clazz;
    private String sortByField;
    private SortOrder sortOrder;
    private Integer limit;
    private Where<T> where;
    private FieldsFilter fieldsFilter;
    private String pageUrl;
    private String dataEndpoint;
    private boolean estimateCount = false;
    private boolean getAll = false;
    private OfflineMode mode = null;
    private Boolean cleanStorageOnSuccessDownload = null;
    private Boolean saveDownloadedDataToStorage = null;
    private SyncanoCallback backgroundCallback;

    public RequestBuilder(Class<T> clazz) {
        this.clazz = clazz;
        this.syncano = Syncano.getInstance();
    }

    public ResponseGetList<T> get() {
        return (ResponseGetList)this.prepareOfflineRequest().send();
    }

    @Deprecated
    public ResponseGetList<T> getAll() {
        this.getAll(true);
        return (ResponseGetList)this.prepareOfflineRequest().send();
    }

    @Deprecated
    public void getAll(SyncanoCallback<List<T>> callback) {
        this.getAll(true);
        this.prepareOfflineRequest().sendAsync(callback);
    }

    public void get(SyncanoCallback<List<T>> callback) {
        this.prepareOfflineRequest().sendAsync(callback);
    }

    public Response<String> getWithTemplate(String templateName) {
        return this.prepareTemplateRequest(templateName).send();
    }

    public void getWithTemplate(String templateName, SyncanoCallback<String> callback) {
        this.prepareTemplateRequest(templateName).sendAsync(callback);
    }

    public RequestGetList<T> prepareGetRequest() {
        RequestGetList<T> request = this.pageUrl != null ? this.syncano.getObjects(this.clazz, this.pageUrl) : (this.dataEndpoint == null ? this.syncano.getObjects(this.clazz) : this.syncano.getObjectsDataEndpoint(this.clazz, this.dataEndpoint));
        if (this.sortByField != null) {
            request.setOrderBy(this.sortByField, this.sortOrder);
        }
        if (this.limit != null) {
            request.setLimit(this.limit);
        }
        if (this.where != null) {
            request.setWhereFilter(this.where);
        }
        if (this.fieldsFilter != null) {
            request.setFieldsFilter(this.fieldsFilter);
        }
        if (this.estimateCount) {
            request.estimateCount();
        }
        request.setGetAll(this.getAll);
        return request;
    }

    private RequestGet<T> prepareGetOneRequest(int id) {
        return this.syncano.getObject(this.clazz, id);
    }

    public OfflineGetListRequest<T> prepareOfflineRequest() {
        OfflineGetListRequest<T> request = new OfflineGetListRequest<T>(this.prepareGetRequest());
        this.decorateOfflineRequest(request);
        return request;
    }

    public OfflineFetchRequest<T> prepareGetOneOfflineRequest(int id) {
        OfflineFetchRequest<T> request = new OfflineFetchRequest<T>(this.prepareGetOneRequest(id));
        this.decorateOfflineRequest(request);
        return request;
    }

    private void decorateOfflineRequest(OfflineRequest request) {
        if (this.mode != null) {
            request.mode(this.mode);
        }
        if (this.cleanStorageOnSuccessDownload != null) {
            request.cleanStorageOnSuccessDownload(this.cleanStorageOnSuccessDownload);
        }
        if (this.saveDownloadedDataToStorage != null) {
            request.saveDownloadedDataToStorage(this.saveDownloadedDataToStorage);
        }
        request.setBackgroundCallback(this.backgroundCallback);
    }

    public RequestTemplate prepareTemplateRequest(String templateName) {
        return new RequestTemplate(this.prepareGetRequest(), templateName);
    }

    public Response<T> get(int id) {
        return this.prepareGetOneOfflineRequest(id).send();
    }

    public void get(int id, SyncanoCallback<T> callback) {
        this.prepareGetOneOfflineRequest(id).sendAsync(callback);
    }

    public RequestBuilder<T> on(Syncano syncano) {
        this.syncano = syncano;
        return this;
    }

    public RequestBuilder<T> orderBy(String fieldName) {
        return this.orderBy(fieldName, SortOrder.ASCENDING);
    }

    public RequestBuilder<T> orderBy(String fieldName, SortOrder sortOrder) {
        this.sortByField = fieldName;
        this.sortOrder = sortOrder;
        return this;
    }

    public RequestBuilder<T> getAll(boolean getAll) {
        this.getAll = getAll;
        return this;
    }

    public RequestBuilder<T> selectFields(FilterType filterType, String ... fields) {
        this.fieldsFilter = new FieldsFilter(filterType, fields);
        return this;
    }

    public RequestBuilder<T> selectFields(FilterType filterType, List<String> fields) {
        this.fieldsFilter = new FieldsFilter(filterType, fields);
        return this;
    }

    public RequestBuilder<T> setFieldsFilter(FieldsFilter fieldsFilter) {
        this.fieldsFilter = fieldsFilter;
        return this;
    }

    public RequestBuilder<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public RequestBuilder<T> estimateCount() {
        this.estimateCount = true;
        return this;
    }

    public RequestBuilder<T> page(String pageUrl) {
        this.pageUrl = pageUrl;
        return this;
    }

    public Where<T> where() {
        this.where = new Where(this);
        return this.where;
    }

    public Response<Integer> getCountEstimation() {
        return new RequestCount(this.prepareGetRequest()).send();
    }

    public void getCountEstimation(SyncanoCallback<Integer> callback) {
        new RequestCount(this.prepareGetRequest()).sendAsync(callback);
    }

    @Deprecated
    public RequestBuilder<T> tableView(String viewName) {
        return this.dataEndpoint(viewName);
    }

    public RequestBuilder<T> dataEndpoint(String name) {
        this.dataEndpoint = name;
        return this;
    }

    public RequestBuilder<T> mode(OfflineMode mode) {
        this.mode = mode;
        return this;
    }

    public RequestBuilder<T> cleanStorageOnSuccessDownload(boolean clean) {
        this.cleanStorageOnSuccessDownload = clean;
        return this;
    }

    public RequestBuilder<T> saveDownloadedDataToStorage(boolean save) {
        this.saveDownloadedDataToStorage = save;
        return this;
    }

    public RequestBuilder<T> backgroundCallback(SyncanoCallback callback) {
        this.backgroundCallback = callback;
        return this;
    }
}

