/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.simple;

import com.syncano.library.Syncano;
import com.syncano.library.api.IncrementBuilder;
import com.syncano.library.api.Response;
import com.syncano.library.api.SendRequest;
import com.syncano.library.callbacks.SyncanoCallback;
import com.syncano.library.data.Entity;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.offline.OfflineDeleteRequest;
import com.syncano.library.offline.OfflineFetchRequest;
import com.syncano.library.offline.OfflineMode;
import com.syncano.library.offline.OfflineRequest;
import com.syncano.library.offline.OfflineSaveRequest;
import java.util.HashSet;

public abstract class ObjectRequestBuilder
extends Entity {
    private Syncano syncano;
    private IncrementBuilder incrementBuilder = new IncrementBuilder();
    private HashSet<String> fieldsToClear = new HashSet();
    private OfflineMode mode = null;
    private Boolean cleanStorageOnSuccessDownload = null;
    private Boolean saveDownloadedDataToStorage = null;
    private SyncanoCallback<? extends SyncanoObject> backgroundCallback;

    public <T extends SyncanoObject> T clearField(String fieldName) {
        this.fieldsToClear.add(fieldName);
        return (T)((SyncanoObject)this);
    }

    public <T extends SyncanoObject> T removeFromClearList(String fieldName) {
        this.fieldsToClear.remove(fieldName);
        return (T)((SyncanoObject)this);
    }

    public boolean isOnClearList(String fieldName) {
        return this.fieldsToClear.contains(fieldName);
    }

    public boolean hasAnyFieldsToClear() {
        return !this.fieldsToClear.isEmpty();
    }

    public IncrementBuilder getIncrementBuilder() {
        return this.incrementBuilder;
    }

    public <T extends SyncanoObject> T increment(String fieldName, int value) {
        this.incrementBuilder.increment(fieldName, value);
        return (T)((SyncanoObject)this);
    }

    public <T extends SyncanoObject> T decrement(String fieldName, int value) {
        this.incrementBuilder.decrement(fieldName, value);
        return (T)((SyncanoObject)this);
    }

    public Syncano getSyncano() {
        if (this.syncano == null) {
            return Syncano.getInstance();
        }
        return this.syncano;
    }

    public <T extends SyncanoObject> T on(Syncano syncano) {
        this.syncano = syncano;
        return (T)((SyncanoObject)this);
    }

    public <T extends SyncanoObject> Response<T> save() {
        OfflineSaveRequest<T> req = this.prepareSaveRequest(true);
        return req.send();
    }

    public <T extends SyncanoObject> void save(SyncanoCallback<T> callback) {
        OfflineSaveRequest<T> req = this.prepareSaveRequest(false);
        req.sendAsync(callback);
    }

    public <T extends SyncanoObject> Response<T> delete() {
        OfflineDeleteRequest<T> req = this.prepareDeleteRequest();
        return req.send();
    }

    public <T extends SyncanoObject> void delete(SyncanoCallback<T> callback) {
        OfflineDeleteRequest<T> req = this.prepareDeleteRequest();
        req.sendAsync(callback);
    }

    public <T extends SyncanoObject> Response<T> fetch() {
        OfflineFetchRequest<T> req = this.prepareFetchRequest();
        return req.send();
    }

    public <T extends SyncanoObject> void fetch(SyncanoCallback<T> callback) {
        OfflineFetchRequest<T> req = this.prepareFetchRequest();
        req.sendAsync(callback);
    }

    public void resetRequestBuildingFields() {
        this.incrementBuilder = new IncrementBuilder();
        this.fieldsToClear = new HashSet();
        this.mode = null;
        this.cleanStorageOnSuccessDownload = null;
        this.saveDownloadedDataToStorage = null;
    }

    private <T extends SyncanoObject> void decorateOfflineRequest(OfflineRequest<T> request) {
        if (this.mode != null) {
            request.mode(this.mode);
        }
        if (this.cleanStorageOnSuccessDownload != null) {
            request.cleanStorageOnSuccessDownload(this.cleanStorageOnSuccessDownload);
        }
        if (this.saveDownloadedDataToStorage != null) {
            request.saveDownloadedDataToStorage(this.saveDownloadedDataToStorage);
        }
        request.setBackgroundCallback(this.backgroundCallback);
    }

    private <T extends SyncanoObject> OfflineSaveRequest<T> prepareSaveRequest(boolean updateGivenObject) {
        SendRequest onlineRequest = this.getId() == null ? this.getSyncano().createObject((SyncanoObject)this, updateGivenObject) : this.getSyncano().updateObject((SyncanoObject)this, updateGivenObject);
        OfflineSaveRequest<SyncanoObject> offlineRequest = new OfflineSaveRequest<SyncanoObject>(onlineRequest);
        this.decorateOfflineRequest(offlineRequest);
        return offlineRequest;
    }

    private <T extends SyncanoObject> OfflineFetchRequest<T> prepareFetchRequest() {
        OfflineFetchRequest<SyncanoObject> offlineRequest = new OfflineFetchRequest<SyncanoObject>(this.getSyncano().getObject((SyncanoObject)this));
        this.decorateOfflineRequest(offlineRequest);
        return offlineRequest;
    }

    private <T extends SyncanoObject> OfflineDeleteRequest<T> prepareDeleteRequest() {
        OfflineDeleteRequest<SyncanoObject> offlineRequest = new OfflineDeleteRequest<SyncanoObject>(this.getSyncano().deleteObject((SyncanoObject)this));
        this.decorateOfflineRequest(offlineRequest);
        return offlineRequest;
    }

    public ObjectRequestBuilder mode(OfflineMode mode) {
        this.mode = mode;
        return this;
    }

    public ObjectRequestBuilder cleanStorageOnSuccessDownload(boolean clean) {
        this.cleanStorageOnSuccessDownload = clean;
        return this;
    }

    public ObjectRequestBuilder saveDownloadedDataToStorage(boolean save) {
        this.saveDownloadedDataToStorage = save;
        return this;
    }

    public ObjectRequestBuilder backgroundCallback(SyncanoCallback<? extends SyncanoObject> callback) {
        this.backgroundCallback = callback;
        return this;
    }
}

