/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.parser;

import android.text.TextUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.syncano.library.annotation.SyncanoField;
import com.syncano.library.choice.FieldType;
import com.syncano.library.data.SyncanoFile;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.parser.GsonParser;
import com.syncano.library.utils.SyncanoClassHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;

class SyncanoObjectSerializer
implements JsonSerializer<SyncanoObject> {
    private GsonParser.GsonParseConfig config;

    public SyncanoObjectSerializer(GsonParser.GsonParseConfig config) {
        this.config = config;
    }

    public JsonElement serialize(SyncanoObject localObject, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        Collection<Field> fields = SyncanoClassHelper.findAllSyncanoFields(localObject.getClass());
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                JsonElement jsonElement;
                String keyName = this.config.forLocalStorage ? SyncanoClassHelper.getOfflineFieldName(field) : SyncanoClassHelper.getFieldName(field);
                if (localObject.isOnClearList(keyName)) {
                    jsonObject.add(keyName, jsc.serialize(null));
                    continue;
                }
                if (this.shouldSkipField(field, localObject) || (jsonElement = this.toJsonObject(localObject, field, jsc)) == null) continue;
                jsonObject.add(keyName, jsonElement);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    private boolean shouldSkipField(Field f, SyncanoObject localObject) throws IllegalAccessException {
        SyncanoField syncanoField = f.getAnnotation(SyncanoField.class);
        return syncanoField == null || !this.config.serializeReadOnlyFields && syncanoField.readOnly() && !syncanoField.required() || f.getType().isAssignableFrom(SyncanoFile.class) && !this.config.serializeUrlFileFields || f.get(localObject) == null || syncanoField.onlyLocal() && !this.config.forLocalStorage;
    }

    private JsonElement toJsonObject(SyncanoObject localObject, Field f, JsonSerializationContext jsc) throws IllegalAccessException {
        if (SyncanoClassHelper.findType(f) == FieldType.REFERENCE) {
            return this.serializeReference(localObject, f);
        }
        if (f.getType().isAssignableFrom(SyncanoFile.class)) {
            SyncanoFile file = (SyncanoFile)f.get(localObject);
            if (file != null && !TextUtils.isEmpty((CharSequence)file.getLink())) {
                return new JsonPrimitive(file.getLink());
            }
            return null;
        }
        return this.serializePlainObject(localObject, f, jsc);
    }

    private JsonElement serializeReference(SyncanoObject localObject, Field f) throws IllegalAccessException {
        SyncanoObject syncanoObject = (SyncanoObject)f.get(localObject);
        if (syncanoObject == null) {
            return null;
        }
        Integer id = syncanoObject.getId();
        if (id == null) {
            return null;
        }
        return new JsonPrimitive((Number)id);
    }

    private JsonElement serializePlainObject(SyncanoObject localObject, Field f, JsonSerializationContext jsc) throws IllegalAccessException {
        return jsc.serialize(f.get(localObject), f.getType());
    }
}

