/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.parser;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonElement;
import com.syncano.library.data.SyncanoFile;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.parser.DateDeserializer;
import com.syncano.library.parser.DateSerializer;
import com.syncano.library.parser.FileDeserializer;
import com.syncano.library.parser.SyncanoExclusionStrategy;
import com.syncano.library.parser.SyncanoFieldNamingStrategy;
import com.syncano.library.parser.SyncanoHashSetDeserializer;
import com.syncano.library.parser.SyncanoHashSetSerializer;
import com.syncano.library.parser.SyncanoObjectDeserializer;
import com.syncano.library.parser.SyncanoObjectSerializer;
import com.syncano.library.utils.NanosDate;
import com.syncano.library.utils.SyncanoHashSet;
import java.lang.reflect.Type;
import java.util.Date;

public class GsonParser {
    public static <T> Gson createGson(T object) {
        return GsonParser.createGson(object, null);
    }

    public static <T> Gson createGson(final T object, GsonParseConfig config) {
        if (config == null) {
            config = new GsonParseConfig();
        }
        if (object instanceof SyncanoObject) {
            return GsonParser.createSyncanoObjectGsonBuilder(object, config).create();
        }
        GsonBuilder gsonBuilder = GsonParser.getDefaultGsonBuilder(config);
        gsonBuilder.registerTypeAdapter(object.getClass(), (Object)new InstanceCreator<T>(){

            public T createInstance(Type type) {
                return object;
            }
        });
        return gsonBuilder.create();
    }

    public static Gson createGson(Class objectType) {
        return GsonParser.createGson(objectType, null);
    }

    public static Gson createGson(Class objectType, GsonParseConfig config) {
        if (config == null) {
            config = new GsonParseConfig();
        }
        if (SyncanoObject.class.isAssignableFrom(objectType)) {
            return GsonParser.createSyncanoObjectGsonBuilder(null, config).create();
        }
        return GsonParser.getDefaultGsonBuilder(config).create();
    }

    private static <T> GsonBuilder createSyncanoObjectGsonBuilder(T object, GsonParseConfig config) {
        GsonBuilder gsonBuilder = GsonParser.getDefaultGsonBuilder(config);
        gsonBuilder.registerTypeHierarchyAdapter(SyncanoObject.class, (Object)new SyncanoObjectSerializer(config));
        if (object != null) {
            gsonBuilder.registerTypeHierarchyAdapter(SyncanoObject.class, (Object)new SyncanoObjectDeserializer(object, config));
        }
        gsonBuilder.serializeNulls();
        return gsonBuilder;
    }

    private static <T> GsonBuilder getDefaultGsonBuilder(GsonParseConfig config) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeHierarchyAdapter(SyncanoObject.class, (Object)new SyncanoObjectDeserializer(null, config));
        gsonBuilder.registerTypeAdapter(NanosDate.class, (Object)new DateSerializer());
        gsonBuilder.registerTypeAdapter(NanosDate.class, (Object)new DateDeserializer());
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateSerializer());
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateDeserializer());
        gsonBuilder.registerTypeAdapter(SyncanoHashSet.class, (Object)new SyncanoHashSetDeserializer());
        gsonBuilder.registerTypeAdapter(SyncanoHashSet.class, (Object)new SyncanoHashSetSerializer());
        gsonBuilder.registerTypeAdapter(SyncanoFile.class, (Object)new FileDeserializer());
        gsonBuilder.setFieldNamingStrategy((FieldNamingStrategy)new SyncanoFieldNamingStrategy());
        gsonBuilder.addSerializationExclusionStrategy((ExclusionStrategy)new SyncanoExclusionStrategy(config.serializeReadOnlyFields));
        return gsonBuilder;
    }

    public static String getJsonElementAsString(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            return "";
        }
        if (jsonElement.isJsonPrimitive()) {
            return jsonElement.getAsString();
        }
        return jsonElement.toString();
    }

    public static class GsonParseConfig {
        public boolean serializeReadOnlyFields = false;
        public boolean forLocalStorage = false;
        public boolean serializeUrlFileFields = false;
    }
}

