/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.offline;

import android.content.Context;
import android.util.Log;
import com.syncano.library.annotation.SyncanoClass;
import com.syncano.library.api.Response;
import com.syncano.library.api.ResultRequest;
import com.syncano.library.api.SendRequest;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.offline.OfflineHelper;
import com.syncano.library.offline.OfflineRequest;
import com.syncano.library.utils.SyncanoClassHelper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;

public class OfflineSaveRequest<T extends SyncanoObject>
extends OfflineRequest<T> {
    public OfflineSaveRequest(SendRequest<T> request) {
        super(request);
        SyncanoClass clazzAnnotation = request.getResultType().getAnnotation(SyncanoClass.class);
        this.mode(clazzAnnotation.saveMode());
        this.cleanStorageOnSuccessDownload(false);
    }

    @Override
    public Response<T> doOnlineRequest(ResultRequest<T> request, boolean cleanStorageOnSuccessDownload, boolean saveDownloadedDataToStorage) {
        Response onlineResponse = request.send();
        if (onlineResponse.isSuccess()) {
            Context ctx = this.getSyncano().getAndroidContext();
            Class type = request.getResultType();
            if (cleanStorageOnSuccessDownload) {
                OfflineHelper.clearTable(ctx, type);
            }
            if (saveDownloadedDataToStorage) {
                OfflineHelper.writeObjects(ctx, Collections.singletonList(onlineResponse.getData()), type);
            }
        }
        return onlineResponse;
    }

    @Override
    public Response<T> doLocalRequest(ResultRequest<T> request) {
        SyncanoObject data = (SyncanoObject)request.getResultObject();
        if (data == null) {
            throw new RuntimeException("Trying to save null");
        }
        if (data.getIncrementBuilder().hasAdditionFields()) {
            Log.e((String)OfflineSaveRequest.class.getSimpleName(), (String)"Incrementing fields doesn't work on local storage calls");
        }
        Collection<Field> fields = SyncanoClassHelper.findAllSyncanoFields(data.getClass());
        for (Field f : fields) {
            if (!data.isOnClearList(SyncanoClassHelper.getFieldName(f))) continue;
            f.setAccessible(true);
            try {
                f.set(data, null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (data.getId() == null || data.getId() == 0) {
            data.setId(null);
        }
        Context ctx = this.getSyncano().getAndroidContext();
        OfflineHelper.writeObjects(ctx, Collections.singletonList(data), request.getResultType());
        Response<SyncanoObject> response = new Response<SyncanoObject>();
        response.setData(data).setDataFromLocalStorage(true).setResultCode(0);
        return response;
    }

    @Override
    public void afterRequests(ResultRequest<T> onlineRequest) {
        SyncanoObject data = (SyncanoObject)onlineRequest.getResultObject();
        if (data != null) {
            data.resetRequestBuildingFields();
        }
    }
}

