/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.offline;

import com.syncano.library.annotation.SyncanoClass;
import com.syncano.library.api.Request;
import com.syncano.library.api.Response;
import com.syncano.library.api.ResultRequest;
import com.syncano.library.callbacks.SyncanoCallback;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.offline.OfflineMode;

public abstract class OfflineRequest<T>
extends Request<T> {
    private ResultRequest<T> onlineRequest;
    private OfflineMode mode;
    private Boolean cleanStorageOnSuccessDownload;
    private Boolean saveDownloadedDataToStorage;
    private SyncanoCallback<T> backgroundCallback = null;

    public OfflineRequest(ResultRequest<T> onlineRequest) {
        super(onlineRequest.getSyncano());
        if (!SyncanoObject.class.isAssignableFrom(onlineRequest.getResultType())) {
            throw new RuntimeException("Using offline storage is only possible for SyncanoObject objects");
        }
        this.onlineRequest = onlineRequest;
        SyncanoClass classAnnotation = onlineRequest.getResultType().getAnnotation(SyncanoClass.class);
        this.mode = classAnnotation.getMode();
        this.cleanStorageOnSuccessDownload = classAnnotation.cleanStorageOnSuccessDownload();
        this.saveDownloadedDataToStorage = classAnnotation.saveDownloadedDataToStorage();
    }

    public OfflineRequest<T> setBackgroundCallback(SyncanoCallback<T> callback) {
        this.backgroundCallback = callback;
        return this;
    }

    public SyncanoCallback<T> getBackgroundCallback() {
        return this.backgroundCallback;
    }

    public OfflineRequest<T> mode(OfflineMode mode) {
        this.mode = mode;
        return this;
    }

    public OfflineRequest<T> cleanStorageOnSuccessDownload(boolean clean) {
        this.cleanStorageOnSuccessDownload = clean;
        return this;
    }

    public OfflineRequest<T> saveDownloadedDataToStorage(boolean save) {
        this.saveDownloadedDataToStorage = save;
        return this;
    }

    @Override
    public Response<T> send() {
        Response<T> response = null;
        switch (this.mode) {
            case ONLINE: {
                response = this.doOnlineRequest(this.onlineRequest, this.cleanStorageOnSuccessDownload, this.saveDownloadedDataToStorage);
                this.afterRequests(this.onlineRequest);
                break;
            }
            case LOCAL_WHEN_ONLINE_FAILED: {
                Response<T> onlineResponse = this.doOnlineRequest(this.onlineRequest, this.cleanStorageOnSuccessDownload, this.saveDownloadedDataToStorage);
                response = onlineResponse.isSuccess() ? onlineResponse : this.doLocalRequest(this.onlineRequest);
                this.afterRequests(this.onlineRequest);
                break;
            }
            case LOCAL_ONLINE_IN_BACKGROUND: {
                response = this.doLocalRequest(this.onlineRequest);
                Request.runAsync(new Request<T>(null){

                    @Override
                    public Response<T> send() {
                        Response response = OfflineRequest.this.doOnlineRequest(OfflineRequest.this.onlineRequest, OfflineRequest.this.cleanStorageOnSuccessDownload, OfflineRequest.this.saveDownloadedDataToStorage);
                        OfflineRequest.this.afterRequests(OfflineRequest.this.onlineRequest);
                        return response;
                    }
                }, this.backgroundCallback);
                break;
            }
            case LOCAL: {
                response = this.doLocalRequest(this.onlineRequest);
                this.afterRequests(this.onlineRequest);
            }
        }
        return response;
    }

    public void afterRequests(ResultRequest<T> onlineRequest) {
    }

    public abstract Response<T> doOnlineRequest(ResultRequest<T> var1, boolean var2, boolean var3);

    public abstract Response<T> doLocalRequest(ResultRequest<T> var1);
}

