/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.offline;

import android.content.Context;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syncano.library.api.Where;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.offline.OfflineHelper;
import com.syncano.library.utils.SyncanoClassHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OfflineQueryBuilder {
    private String selection;
    private String[] selArgs;
    private String orderBy;

    public OfflineQueryBuilder(Context ctx, Class<? extends SyncanoObject> type, Where where, String orderBy) {
        if (where == null) {
            return;
        }
        JsonObject map = where.getQueryMap();
        ArrayList<String> expressions = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry entry : map.entrySet()) {
            String column = this.findColumnName(type, (String)entry.getKey());
            for (Map.Entry expr : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                boolean addValue = true;
                switch ((String)expr.getKey()) {
                    case "_is": {
                        Field f = SyncanoClassHelper.findField(type, (String)entry.getKey());
                        Where w = new Where();
                        w.setQueryMap(((JsonElement)expr.getValue()).getAsJsonObject());
                        List<SyncanoObject> refs = OfflineHelper.readObjects(ctx, f.getType(), w, null);
                        JsonArray ids = new JsonArray();
                        for (SyncanoObject so : refs) {
                            ids.add((Number)so.getId());
                        }
                        this.addInFilter(column, expressions, values, ids);
                        addValue = false;
                        break;
                    }
                    case "_gt": {
                        expressions.add("(" + column + ">?)");
                        break;
                    }
                    case "_gte": {
                        expressions.add("(" + column + ">=?)");
                        break;
                    }
                    case "_lt": {
                        expressions.add("(" + column + "<?)");
                        break;
                    }
                    case "_lte": {
                        expressions.add("(" + column + "<=?)");
                        break;
                    }
                    case "_eq": {
                        expressions.add("(" + column + "==?)");
                        break;
                    }
                    case "_ieq": {
                        expressions.add("(" + column + "==? COLLATE NOCASE)");
                        break;
                    }
                    case "_neq": {
                        expressions.add("(" + column + "!=?)");
                        break;
                    }
                    case "_exists": {
                        boolean exists = ((JsonElement)expr.getValue()).getAsBoolean();
                        if (exists) {
                            expressions.add("(" + column + " IS NOT NULL)");
                        } else {
                            expressions.add("(" + column + " IS NULL)");
                        }
                        addValue = false;
                        break;
                    }
                    case "_in": {
                        this.addInFilter(column, expressions, values, ((JsonElement)expr.getValue()).getAsJsonArray());
                        addValue = false;
                        break;
                    }
                    case "_startswith": {
                        expressions.add("(" + column + " GLOB ?)");
                        values.add(((JsonElement)expr.getValue()).getAsString() + "*");
                        addValue = false;
                        break;
                    }
                    case "_istartswith": {
                        expressions.add("(" + column + " LIKE ?)");
                        values.add(((JsonElement)expr.getValue()).getAsString() + "%");
                        addValue = false;
                        break;
                    }
                    case "_endswith": {
                        expressions.add("(" + column + " GLOB ?)");
                        values.add("*" + ((JsonElement)expr.getValue()).getAsString());
                        addValue = false;
                        break;
                    }
                    case "_iendswith": {
                        expressions.add("(" + column + " LIKE ?)");
                        values.add("%" + ((JsonElement)expr.getValue()).getAsString());
                        addValue = false;
                        break;
                    }
                    case "_contains": {
                        expressions.add("(" + column + " GLOB ?)");
                        values.add("*" + ((JsonElement)expr.getValue()).getAsString() + "*");
                        addValue = false;
                        break;
                    }
                    case "_icontains": {
                        expressions.add("(" + column + " LIKE ?)");
                        values.add("%" + ((JsonElement)expr.getValue()).getAsString() + "%");
                        addValue = false;
                    }
                }
                if (!addValue) continue;
                values.add(((JsonElement)expr.getValue()).getAsString());
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < expressions.size(); ++i) {
            sb.append((String)expressions.get(i));
            if (i >= expressions.size() - 1) continue;
            sb.append(" AND ");
        }
        this.selection = sb.toString();
        this.selArgs = values.toArray(new String[values.size()]);
        if (orderBy != null) {
            this.orderBy = orderBy.startsWith("-") ? this.findColumnName(type, orderBy.substring(1)) + " DESC" : this.findColumnName(type, orderBy) + " ASC";
        }
    }

    private void addInFilter(String column, ArrayList<String> expressions, ArrayList<String> values, JsonArray arr) {
        StringBuilder sb = new StringBuilder("(");
        sb.append(column);
        sb.append(" IN (");
        for (int i = 0; i < arr.size(); ++i) {
            values.add(arr.get(i).getAsString());
            sb.append('?');
            if (i >= arr.size() - 1) continue;
            sb.append(',');
        }
        sb.append("))");
        expressions.add(sb.toString());
    }

    private String findColumnName(Class<? extends SyncanoObject> type, String key) {
        return SyncanoClassHelper.getOfflineFieldName(SyncanoClassHelper.findField(type, key));
    }

    public String getSelection() {
        return this.selection;
    }

    public String[] getSelArgs() {
        return this.selArgs;
    }

    public String getOrderBy() {
        return this.orderBy;
    }
}

