/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.offline;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syncano.library.annotation.SyncanoClass;
import com.syncano.library.api.Where;
import com.syncano.library.choice.FieldType;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.offline.OfflineQueryBuilder;
import com.syncano.library.parser.GsonParser;
import com.syncano.library.utils.SyncanoClassHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OfflineHelper {
    private static final int VERSION = 1;
    private static final String TABLE_NAME = "syncano";
    private static final String MIGRATE_METHOD_NAME = "migrate";
    private static HashSet<String> checkedMigrations = new HashSet();

    public static <T extends SyncanoObject> List<T> readObjects(Context ctx, Class<T> type) {
        return OfflineHelper.readObjects(ctx, type, null, null);
    }

    public static <T extends SyncanoObject> List<T> readObjects(Context ctx, Class<T> type, Where<T> where, String orderBy) {
        OfflineHelper.checkContext(ctx);
        SQLiteOpenHelper sqlHelper = OfflineHelper.initDb(ctx, type);
        SQLiteDatabase db = sqlHelper.getReadableDatabase();
        ArrayList<Object> list = new ArrayList<Object>();
        OfflineQueryBuilder query = new OfflineQueryBuilder(ctx, type, where, orderBy);
        Cursor c = db.query(TABLE_NAME, null, query.getSelection(), query.getSelArgs(), null, null, query.getOrderBy());
        GsonParser.GsonParseConfig config = new GsonParser.GsonParseConfig();
        config.forLocalStorage = true;
        Gson gson = GsonParser.createGson(type, config);
        String[] columns = c.getColumnNames();
        c.moveToFirst();
        while (!c.isAfterLast()) {
            JsonObject json = new JsonObject();
            for (String column : columns) {
                json.addProperty(column, c.getString(c.getColumnIndex(column)));
            }
            list.add(gson.fromJson((JsonElement)json, type));
            c.moveToNext();
        }
        c.close();
        db.close();
        return list;
    }

    public static <T extends SyncanoObject> T readObject(Context ctx, Class<T> type, int id) {
        OfflineHelper.checkContext(ctx);
        GsonParser.GsonParseConfig config = new GsonParser.GsonParseConfig();
        config.forLocalStorage = true;
        Gson gson = GsonParser.createGson(type, config);
        return OfflineHelper.readObject(ctx, gson, type, id);
    }

    public static <T extends SyncanoObject> T readObject(Context ctx, T obj) {
        OfflineHelper.checkContext(ctx);
        GsonParser.GsonParseConfig config = new GsonParser.GsonParseConfig();
        config.forLocalStorage = true;
        Gson gson = GsonParser.createGson(obj, config);
        return (T)OfflineHelper.readObject(ctx, gson, obj.getClass(), obj.getId());
    }

    public static <T extends SyncanoObject> T readObject(Context ctx, Gson gson, Class<T> type, int id) {
        OfflineHelper.checkContext(ctx);
        SQLiteOpenHelper sqlHelper = OfflineHelper.initDb(ctx, type);
        SQLiteDatabase db = sqlHelper.getReadableDatabase();
        OfflineQueryBuilder query = new OfflineQueryBuilder(ctx, type, new Where().eq("id", id), null);
        Cursor c = db.query(TABLE_NAME, null, query.getSelection(), query.getSelArgs(), null, null, query.getOrderBy());
        String[] columns = c.getColumnNames();
        c.moveToFirst();
        SyncanoObject object = null;
        if (c.getCount() != 0) {
            JsonObject json = new JsonObject();
            for (String column : columns) {
                json.addProperty(column, c.getString(c.getColumnIndex(column)));
            }
            object = (SyncanoObject)gson.fromJson((JsonElement)json, type);
        }
        c.close();
        db.close();
        return (T)object;
    }

    public static <T extends SyncanoObject> boolean deleteObject(Context ctx, Class<T> type, int id) {
        OfflineHelper.checkContext(ctx);
        SQLiteOpenHelper sqlHelper = OfflineHelper.initDb(ctx, type);
        SQLiteDatabase db = sqlHelper.getWritableDatabase();
        OfflineQueryBuilder query = new OfflineQueryBuilder(ctx, type, new Where().eq("id", id), null);
        int delNum = db.delete(TABLE_NAME, query.getSelection(), query.getSelArgs());
        return delNum == 1;
    }

    public static void writeObjects(Context ctx, List<? extends SyncanoObject> objects, Class<? extends SyncanoObject> type) {
        OfflineHelper.checkContext(ctx);
        SQLiteOpenHelper sqlHelper = OfflineHelper.initDb(ctx, type);
        SQLiteDatabase db = sqlHelper.getWritableDatabase();
        GsonParser.GsonParseConfig config = new GsonParser.GsonParseConfig();
        config.serializeReadOnlyFields = true;
        config.serializeUrlFileFields = true;
        config.forLocalStorage = true;
        Gson gson = GsonParser.createGson(type, config);
        for (SyncanoObject syncanoObject : objects) {
            JsonObject jsonized = gson.toJsonTree((Object)syncanoObject).getAsJsonObject();
            ContentValues values = new ContentValues();
            for (Map.Entry entry : jsonized.entrySet()) {
                values.put((String)entry.getKey(), GsonParser.getJsonElementAsString((JsonElement)entry.getValue()));
            }
            long id = db.insertWithOnConflict(TABLE_NAME, "channel", values, 5);
            syncanoObject.setLocalId(id);
        }
        db.close();
    }

    private static SQLiteOpenHelper initDb(Context ctx, Class<? extends SyncanoObject> type) {
        String dbName = OfflineHelper.getDbName(type);
        if (type.getAnnotation(SyncanoClass.class).version() == 1 || checkedMigrations.contains(dbName)) {
            return OfflineHelper.getSQLiteOpenHelper(ctx, type);
        }
        LinkedList<Class<? extends SyncanoObject>> versions = new LinkedList<Class<? extends SyncanoObject>>();
        Class<? extends SyncanoObject> typeToCheck = type;
        do {
            versions.push(typeToCheck);
        } while (!OfflineHelper.migrate(ctx, versions, typeToCheck = ((Class)versions.peek()).getAnnotation(SyncanoClass.class).previousVersion()));
        return OfflineHelper.getSQLiteOpenHelper(ctx, type);
    }

    public static void reinitHelper() {
        checkedMigrations = new HashSet();
    }

    private static boolean migrate(Context ctx, LinkedList<Class<? extends SyncanoObject>> versions, Class<? extends SyncanoObject> oldTypeToCheck) {
        if (SyncanoClass.NOT_SET.class.equals(oldTypeToCheck)) {
            return true;
        }
        String oldDbName = OfflineHelper.getDbName(oldTypeToCheck);
        checkedMigrations.add(oldDbName);
        if (!OfflineHelper.dbExists(ctx, oldDbName)) {
            return false;
        }
        OfflineHelper.performMigration(ctx, versions, oldTypeToCheck);
        return true;
    }

    private static void performMigration(Context ctx, LinkedList<Class<? extends SyncanoObject>> versions, Class<? extends SyncanoObject> foundOldVersion) {
        Class<? extends SyncanoObject> type = versions.pollLast();
        checkedMigrations.add(OfflineHelper.getDbName(type));
        try {
            Method m = type.getMethod(MIGRATE_METHOD_NAME, Integer.TYPE);
            m.invoke(null, foundOldVersion.getAnnotation(SyncanoClass.class).version());
        }
        catch (Exception e1) {
            try {
                Method m = type.getMethod(MIGRATE_METHOD_NAME, new Class[0]);
                if (!versions.isEmpty()) {
                    OfflineHelper.performMigration(ctx, versions, foundOldVersion);
                }
                m.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ctx.deleteDatabase(OfflineHelper.getDbName(foundOldVersion));
    }

    private static SQLiteOpenHelper getSQLiteOpenHelper(Context ctx, final Class<? extends SyncanoObject> type) {
        return new SQLiteOpenHelper(ctx, OfflineHelper.getDbName(type), null, 1){

            public void onCreate(SQLiteDatabase db) {
                String createSql = OfflineHelper.generateCreateSql(type);
                db.execSQL(createSql);
            }

            public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            }
        };
    }

    private static boolean dbExists(Context ctx, String dbName) {
        SQLiteDatabase checkDB = null;
        try {
            checkDB = SQLiteDatabase.openDatabase((String)ctx.getDatabasePath(dbName).getPath(), null, (int)1);
            checkDB.close();
            return true;
        }
        catch (Exception e) {
            if (checkDB != null) {
                checkDB.close();
            }
            return false;
        }
    }

    private static String generateCreateSql(Class<? extends SyncanoObject> type) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(TABLE_NAME);
        sb.append(" (");
        Collection<Field> fields = SyncanoClassHelper.findAllSyncanoFields(type);
        for (Field f : fields) {
            String fieldName = SyncanoClassHelper.getOfflineFieldName(f);
            if (fieldName.equals("id") || fieldName.equals("id_local")) continue;
            sb.append(fieldName);
            sb.append(' ');
            sb.append(OfflineHelper.getFieldSqlTypeName(f));
            sb.append(", ");
        }
        sb.append("id");
        sb.append(" INTEGER UNIQUE, ");
        sb.append("id_local");
        sb.append(" INTEGER PRIMARY KEY )");
        return sb.toString();
    }

    private static String getFieldSqlTypeName(Field f) {
        FieldType type = SyncanoClassHelper.findType(f);
        if (type == null || type == FieldType.NOT_SET) {
            throw new RuntimeException("Can't get type of field " + SyncanoClassHelper.getFieldName(f));
        }
        switch (type) {
            case STRING: 
            case TEXT: 
            case FILE: 
            case DATETIME: {
                return "TEXT";
            }
            case INTEGER: 
            case REFERENCE: 
            case BOOLEAN: {
                return "INTEGER";
            }
            case FLOAT: {
                return "REAL";
            }
        }
        throw new RuntimeException("Can't get type of field " + SyncanoClassHelper.getFieldName(f));
    }

    private static String getDbName(Class<? extends SyncanoObject> type) {
        SyncanoClass syncanoClass = type.getAnnotation(SyncanoClass.class);
        return syncanoClass.name() + "_" + syncanoClass.version();
    }

    public static void clearTable(Context ctx, Class<? extends SyncanoObject> type) {
        OfflineHelper.checkContext(ctx);
        SQLiteOpenHelper sqlHelper = OfflineHelper.initDb(ctx, type);
        SQLiteDatabase db = sqlHelper.getWritableDatabase();
        db.delete(TABLE_NAME, null, null);
    }

    public static void deleteDatabase(Context ctx, Class<? extends SyncanoObject> type) {
        OfflineHelper.checkContext(ctx);
        ctx.deleteDatabase(OfflineHelper.getDbName(type));
    }

    private static void checkContext(Context ctx) {
        if (ctx == null) {
            throw new RuntimeException("Context null, when trying to use offline function. Pass Android Context when initiating Syncano");
        }
    }
}

