/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.offline;

import android.content.Context;
import com.syncano.library.api.RequestGetList;
import com.syncano.library.api.ResponseGetList;
import com.syncano.library.api.ResultRequest;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.offline.LocalFieldsHelper;
import com.syncano.library.offline.OfflineHelper;
import com.syncano.library.offline.OfflineRequest;
import java.util.Collection;
import java.util.List;

public class OfflineGetListRequest<T extends SyncanoObject>
extends OfflineRequest<List<T>> {
    public OfflineGetListRequest(RequestGetList<T> getRequest) {
        super(getRequest);
    }

    @Override
    public ResponseGetList<T> doOnlineRequest(ResultRequest<List<T>> getRequest, boolean cleanStorageOnSuccessDownload, boolean saveDownloadedDataToStorage) {
        ResponseGetList onlineResponse = (ResponseGetList)getRequest.send();
        if (onlineResponse.isSuccess()) {
            Context ctx = this.getSyncano().getAndroidContext();
            Class type = getRequest.getResultType();
            if (onlineResponse.getData() != null) {
                LocalFieldsHelper.fillWithLocalData(ctx, (Collection)onlineResponse.getData());
            }
            if (cleanStorageOnSuccessDownload) {
                OfflineHelper.clearTable(ctx, type);
            }
            if (saveDownloadedDataToStorage) {
                OfflineHelper.writeObjects(ctx, (List)onlineResponse.getData(), type);
            }
        }
        return onlineResponse;
    }

    @Override
    public ResponseGetList<T> doLocalRequest(ResultRequest<List<T>> getRequest) {
        RequestGetList getListRequest = (RequestGetList)getRequest;
        List data = OfflineHelper.readObjects(this.getSyncano().getAndroidContext(), getListRequest.getResultType(), getListRequest.getWhereFilter(), getListRequest.getOrderByParam());
        ResponseGetList response = new ResponseGetList(this.getSyncano(), getListRequest.getResultType());
        response.setData(data).setDataFromLocalStorage(true).setResultCode(0);
        return response;
    }
}

