/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.offline;

import android.content.Context;
import com.syncano.library.annotation.SyncanoClass;
import com.syncano.library.api.RequestGet;
import com.syncano.library.api.Response;
import com.syncano.library.api.ResultRequest;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.offline.LocalFieldsHelper;
import com.syncano.library.offline.OfflineHelper;
import com.syncano.library.offline.OfflineRequest;
import java.util.Collections;

public class OfflineFetchRequest<T extends SyncanoObject>
extends OfflineRequest<T> {
    public OfflineFetchRequest(RequestGet<T> request) {
        super(request);
        SyncanoClass clazzAnnotation = request.getResultType().getAnnotation(SyncanoClass.class);
        this.mode(clazzAnnotation.getMode());
        this.cleanStorageOnSuccessDownload(false);
    }

    @Override
    public Response<T> doOnlineRequest(ResultRequest<T> request, boolean cleanStorageOnSuccessDownload, boolean saveDownloadedDataToStorage) {
        Response onlineResponse = request.send();
        if (onlineResponse.isSuccess()) {
            Context ctx = this.getSyncano().getAndroidContext();
            if (onlineResponse.getData() != null) {
                LocalFieldsHelper.fillWithLocalData(ctx, (SyncanoObject)onlineResponse.getData());
            }
            Class type = request.getResultType();
            if (cleanStorageOnSuccessDownload) {
                OfflineHelper.clearTable(ctx, type);
            }
            if (saveDownloadedDataToStorage) {
                OfflineHelper.writeObjects(ctx, Collections.singletonList(onlineResponse.getData()), type);
            }
        }
        return onlineResponse;
    }

    @Override
    public Response<T> doLocalRequest(ResultRequest<T> request) {
        RequestGet getRequest = (RequestGet)request;
        Object data = getRequest.getResultObject() != null && getRequest.isSetUpdateGivenObject() ? OfflineHelper.readObject(this.getSyncano().getAndroidContext(), (SyncanoObject)getRequest.getResultObject()) : OfflineHelper.readObject(this.getSyncano().getAndroidContext(), getRequest.getResultType(), getRequest.getRequestedId());
        Response response = new Response();
        response.setData(data).setDataFromLocalStorage(true).setResultCode(0);
        return response;
    }
}

