/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.offline;

import android.content.Context;
import com.syncano.library.annotation.SyncanoClass;
import com.syncano.library.api.RequestDelete;
import com.syncano.library.api.Response;
import com.syncano.library.api.ResultRequest;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.offline.OfflineHelper;
import com.syncano.library.offline.OfflineRequest;

public class OfflineDeleteRequest<T extends SyncanoObject>
extends OfflineRequest<T> {
    public OfflineDeleteRequest(RequestDelete<T> request) {
        super(request);
        SyncanoClass clazzAnnotation = request.getResultType().getAnnotation(SyncanoClass.class);
        this.mode(clazzAnnotation.saveMode());
        this.cleanStorageOnSuccessDownload(false);
    }

    @Override
    public Response<T> doOnlineRequest(ResultRequest<T> onlineRequest, boolean cleanStorageOnSuccessDownload, boolean saveDownloadedDataToStorage) {
        RequestDelete request = (RequestDelete)onlineRequest;
        Response onlineResponse = request.send();
        if (onlineResponse.isSuccess()) {
            Context ctx = this.getSyncano().getAndroidContext();
            Class type = request.getResultType();
            if (cleanStorageOnSuccessDownload) {
                OfflineHelper.clearTable(ctx, type);
            }
            if (saveDownloadedDataToStorage) {
                OfflineHelper.deleteObject(ctx, request.getResultType(), request.getId());
            }
        }
        return onlineResponse;
    }

    @Override
    public Response<T> doLocalRequest(ResultRequest<T> onlineRequest) {
        RequestDelete request = (RequestDelete)onlineRequest;
        Context ctx = this.getSyncano().getAndroidContext();
        boolean success = OfflineHelper.deleteObject(ctx, request.getResultType(), request.getId());
        Response response = new Response();
        response.setDataFromLocalStorage(true);
        response.setResultCode(success ? 0 : 6);
        return response;
    }
}

