/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.offline;

import android.content.Context;
import com.syncano.library.PlatformType;
import com.syncano.library.annotation.SyncanoField;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.offline.OfflineHelper;
import com.syncano.library.utils.SyncanoClassHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;

public class LocalFieldsHelper {
    public static void fillWithLocalData(Context ctx, Collection<? extends SyncanoObject> objects) {
        if (!PlatformType.isAndroid()) {
            return;
        }
        for (SyncanoObject syncanoObject : objects) {
            LocalFieldsHelper.fillWithLocalData(ctx, syncanoObject);
        }
    }

    public static void fillWithLocalData(Context ctx, SyncanoObject obj) {
        if (!PlatformType.isAndroid()) {
            return;
        }
        Collection<Field> localFields = LocalFieldsHelper.findLocalFields(obj.getClass());
        if (localFields.size() == 0) {
            return;
        }
        Object offlineObject = OfflineHelper.readObject(ctx, obj.getClass(), obj.getId());
        if (offlineObject == null) {
            return;
        }
        try {
            for (Field f : localFields) {
                f.setAccessible(true);
                f.set(obj, f.get(offlineObject));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Collection<Field> findLocalFields(Class type) {
        Collection<Field> fields = SyncanoClassHelper.findAllSyncanoFields(type);
        ArrayList<Field> locals = new ArrayList<Field>();
        for (Field f : fields) {
            SyncanoField fieldAnnotation = f.getAnnotation(SyncanoField.class);
            if (!fieldAnnotation.onlyLocal()) continue;
            locals.add(f);
        }
        return locals;
    }
}

